<?php

namespace App\Exports;

use App\Models\Bill;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class CustomerBillParticularExport implements FromView, WithStyles
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function view(): View
    {
        $query = Bill::query();

        $query->select([
            'billing_bills.id as bill_no',
            'customer_id',
            'billDivName',
            'bill_subject_id',
            'particulars',
            'ref_no',
            'ref_date',
            'qty',
            'unit_price_vat',
            'vat_status',
            'vat_percent',
            'installation_date',
            'bill_type',
            'start_date',
            'yearly_increase_percent',
            'increase_start_date',
            'end_date',
            'bill_group',
            'billing_customers.status',
            'billing_customers.customer_name',
        ]);

        $query->join('billing_customers', 'billing_bills.customer_id', '=', 'billing_customers.id');
        $query->where('billing_customers.status', 'Active');
        $query->where('billing_bills.approval', 1);
        $query->where('billing_bills.delete_flag', 0);

        if ($this->request->filled('rpt_customer')) {
            $query->where('customer_id', $this->request->rpt_customer);
            $query->orderBy('billing_bills.id', 'asc');
        } else {
            $query->orderBy('billing_customers.customer_name', 'asc')
                ->orderBy('billing_bills.id', 'asc');
        }

        if ($this->request->filled('rpt_status')) {
            $query->where('billing_bills.status', $this->request->rpt_status);
            $query->with(['billSubject:id,bill_subject']);
        }

        $bills = $query->get();

        return view('report.export.customer-bill-particular-excel', [
            'bills'    => $bills,
            'customer' => $this->request->rpt_customer,
            'status'   => $this->request->rpt_status,
        ]);
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => [ // 1st row
                'font' => [
                    'bold' => true,
                ],
            ],
        ];
    }
}
