<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Bill;
use App\Models\Customer;
use App\Models\Department;
use App\Models\BillSubject;
use App\Models\Settings;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use DB;

class BillDashboardController extends Controller
{
    public function index($id=null)
    {
        if (!auth()->user()->can('View Bill')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $bills = [];
        $address = '';
        if($id && (int)$id>0){
            $customer = Customer::find($id);
            if(!$customer){
                return redirect()->route('bill.dashboard')
                         ->with('error', 'Customer not found.');
            }else{
                $bills = Bill::where('customer_id',$id)->get();
                $address = $customer->address;
            }
        }
        $customer_id = '';
        // $customers = Customer::orderBy('customer_name')->get();

        $distinctCustomerIds = Bill::select('customer_id')->distinct()->pluck('customer_id');
        $customers = Customer::whereIn('id', $distinctCustomerIds)
            ->select('id','customer_name')
            ->orderBy('customer_name', 'asc')
            ->get();

        return view('billDashboard.index', compact('bills','id','customers','address','customer_id'));
    }


    public function billSearch(Request $request)
    {
        $bills = [];
        $id = $request->customer_id;
        $customer_id = $request->customer_id;
        $address = $request->address;
        $from_date = $request->from_date;
        $to_date = $request->to_date;
        $bill_status = $request->bill_status;
        $bill_type = $request->bill_type;
        $filter_type = $request->filter_type;
        $order_by = $request->order_by;

        $dateCon = '';
        if($from_date && $to_date){
            $from_date_cnv = Settings::dateMaker($from_date,'d/m/Y','Y-m-d');
            $to_date_cnv = Settings::dateMaker($to_date,'d/m/Y','Y-m-d');
            $dateCon = " AND STR_TO_DATE(ref_date, '%d/%m/%Y') BETWEEN '$from_date_cnv' AND '$to_date_cnv' ";
        }else{
            if($from_date){
                $from_date_cnv = Settings::dateMaker($from_date,'d/m/Y','Y-m-d');
                $dateCon = " AND STR_TO_DATE(ref_date, '%d/%m/%Y') = '$from_date_cnv' ";
            }
            if($to_date){
                $to_date_cnv = Settings::dateMaker($to_date,'d/m/Y','Y-m-d');
                $dateCon = " AND STR_TO_DATE(ref_date, '%d/%m/%Y') = '$to_date_cnv' ";
            }
        }

        $billCon = '';
        if($bill_type){
            $billCon = " AND bill_type= '$bill_type' ";
        }

        $approvalCon = '';
        if($bill_status==1 || $bill_status==0 || $bill_status=='' || $bill_status==11){
            if($bill_status==''){ //pending
                $approvalCon = " AND approval is null ";
            }else if($bill_status==11){ //all
                $approvalCon = " AND (approval is null OR approval IN (0,1)) ";
            }else{
                $approvalCon = " AND approval= '$bill_status' ";
            }
        }

        $tblBills = Bill::getTableName();
        $bills = DB::select("SELECT *
                FROM $tblBills
                WHERE customer_id=$customer_id
                AND delete_flag=0
                $approvalCon
                $billCon
                $dateCon
                ORDER BY $filter_type $order_by");

        // $customers = Customer::orderBy('customer_name')->get();
        $distinctCustomerIds = Bill::select('customer_id')->where('delete_flag', 0)->distinct()->pluck('customer_id');
        $customers = Customer::whereIn('id', $distinctCustomerIds)
            ->select('id','customer_name')
            ->orderBy('customer_name', 'asc')
            ->get();

        return view('billDashboard.index', compact('bills','id','customers','address','from_date',
            'to_date','bill_status','bill_type','filter_type','order_by','customer_id'));
    }

    public function customerAddress($id=null){
        if($id && $info = Customer::find($id)){
            echo $info->address;
        }else{
            echo '';
        }

    }

    public function show($id)
    {
        if (!auth()->user()->can('View Bill')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $departments = [];
        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        //get department list from api - salaquzzaman @ 05-06-2024
        try{
            $response2 = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/departments/all');

            if ($response2->successful()) {
                $responseData2 = $response2->json();
                if ($responseData2) {
                    $departments = json_encode($responseData2);
                }
            }
        }catch (\Exception $e) {
            // Log::error($e->getMessage());
        }

        $bill = Bill::find($id);
        return view('billDashboard.show', compact('bill','departments'));
    }

}
