<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BillSubject;
use App\Models\GlHead;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;

class BillSubjectController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Manage Setup')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }

    //     $billSubjects = BillSubject::all();

    //     return view('billSubject.index', compact('billSubjects'));
    // }

    public function index(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);

        $billSubjects = BillSubject::paginate($perPage);

        return view('billSubject.index', compact('billSubjects', 'perPage'));
    }


    public function create()
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $gl_subject = [];
        $departments = [];

        $getHead = GlHead::where('gl_subject',strtoupper('Income from service'))->first();
        if($getHead){
            $gl_code = $getHead->gl_code;

            //get income service list from api - salaquzzaman @ 01-06-2024
            $token = session('api_token');
            $api_ip = env("API_IP");
            $company_number = env("COMPANY_NUMBER");

            try{
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip.'/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $gl_code,
                    'companyNo' => $company_number,
                ]);

                if ($response->successful()) {
                    $responseData = $response->json();
                    if ($responseData && isset($responseData['accHeadDetailsInfos'])) {
                        $gl_subject = $responseData['accHeadDetailsInfos'];
                    }
                }
            }catch (\Exception $e) {
                // Log::error($e->getMessage());
            }
        }

        try{
            $response2 = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/departments/all');

            if ($response2->successful()) {
                $responseData2 = $response2->json();
                if ($responseData2) {
                    $departments = $responseData2;
                }
            }
        }catch (\Exception $e) {
            // Log::error($e->getMessage());
        }

        return view('billSubject.create',compact('gl_subject','departments'));
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $validator = Validator::make($request->all(), [
            'bill_subject' => 'required',
            'gl_subject' => 'required',
            'gl_code' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('bill-subject.index')
                         ->with('error', 'Missing required fields.');
        }

        BillSubject::create($request->all());

        return redirect()->route('bill-subject.index')
                         ->with('success', 'Bill Subject created successfully.');

    }

    public function edit(BillSubject $billSubject)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $gl_subject = [];
        $departments = [];

        $getHead = GlHead::where('gl_subject',strtoupper('Income from service'))->first();
        if($getHead){
            $gl_code = $getHead->gl_code;

            //get income service list from api - salaquzzaman @ 01-06-2024
            $token = session('api_token');
            $api_ip = env("API_IP");
            $company_number = env("COMPANY_NUMBER");

            try{
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip.'/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $gl_code,
                    'companyNo' => $company_number,
                ]);

                if ($response->successful()) {
                    $responseData = $response->json();
                    if ($responseData && isset($responseData['accHeadDetailsInfos'])) {
                        $gl_subject = $responseData['accHeadDetailsInfos'];
                    }
                }
            }catch (\Exception $e) {
                // Log::error($e->getMessage());
            }

        }

        try{
            $response2 = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/departments/all');

            if ($response2->successful()) {
                $responseData2 = $response2->json();
                if ($responseData2) {
                    $departments = $responseData2;
                }
            }
        }catch (\Exception $e) {
            // Log::error($e->getMessage());
        }

        return view('billSubject.edit', compact('billSubject','gl_subject','departments'));
    }

    public function update(Request $request, BillSubject $billSubject)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $validator = Validator::make($request->all(), [
            'bill_subject' => 'required',
            'gl_subject' => 'required',
            'gl_code' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('bill-subject.index')
                         ->with('error', 'Missing required fields.');
        }

        $billSubject->update($request->all());

        return redirect()->route('bill-subject.index')
                         ->with('success', 'Bill Subject updated successfully.');
    }

    public function destroy(BillSubject $billSubject)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $billSubject->delete();

        return redirect()->route('bill-subject.index')
                         ->with('success', 'Bill Subject deleted successfully.');
    }

    public function incomeListByDivCode($divCode){
        if($divCode=='ALL'){
            $divCode = '';
        }

        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");
        $lst = '<option value="">--Select GL Subject--</option>';
        try{
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/integrate/searchByDivCode', [
                'divCode' => $divCode,
                'acTypeNo' => 2,
                'companyNo' => $company_number,
            ]);

            if ($response->successful()) {
                $responseData = $response->json();
                if ($responseData && isset($responseData['accHeadDetailsInfos'])) {
                    $incomeLists = $responseData['accHeadDetailsInfos'];
                    foreach ($incomeLists as $row) {
                        $lst.='<option value="'.$row['autoAcNo'].'">'.$row['udAcName'].'</option>';
                    }
                }
            }

        }catch (\Exception $e) {
            // Log::error($e->getMessage());
            $lst = '<option value="">Select Income</option>';
        }
        echo $lst;
    }
}
