<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Configuration;
use Illuminate\Support\Facades\Validator;

class ConfigurationController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Manage Setup')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }

    //     $configurations = Configuration::all();
    //     return view('configuration.index', compact('configurations'));
    // }  


    public function index(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);
        $configurations = Configuration::paginate($perPage);

        return view('configuration.index', compact('configurations', 'perPage'));
    }



    public function create()
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        return view('configuration.create');
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'key' => 'required',
            'value' => 'nullable',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('configuration.index')
                         ->with('error', 'Missing required fields.');
        }

        Configuration::create($request->all());

        return redirect()->route('configuration.index')
                         ->with('success', 'Configuration created successfully.');
    }

    public function edit(Configuration $configuration)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        return view('configuration.edit', compact('configuration'));
    }

    public function update(Request $request, Configuration $configuration)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'key' => 'required',
            'value' => 'nullable',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('configuration.index')
                         ->with('error', 'Missing required fields.');
        }

        $configuration->update($request->all());

        return redirect()->route('configuration.index')
                         ->with('success', 'Configuration updated successfully.');
    }

    public function destroy(Configuration $configuration)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        
        $configuration->delete();

        return redirect()->route('configuration.index')
                         ->with('success', 'Configuration deleted successfully.');
    }
}
