<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\GlHead;
use App\Models\Settings;
use App\Models\Bill;
use App\Models\BillProcess;
use App\Models\AttentionPerson;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use DB;

class CustomerController extends Controller
{
    public function index(Request $request)
    {
        if (!auth()->user()->can('View Customer')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);
        $search = $request->input('search');

        $query = Customer::query();

        if ($search) {
            $query->where('customer_name', 'like', '%' . $search . '%');
            $query->orWhere('id', 'like', '%' . $search . '%');
        }

        $customers = $query->orderBy('id', 'desc')->paginate($perPage);

        return view('customer.index', compact('customers', 'perPage', 'search'));
    }

    public function create()
    {

        // $customers = DB::select("select * from billing_customers where newAutoAcNo is null");
        // foreach ($customers as $row){
        //     $customer_id = $row->id;
        //     $customer_name = $row->customer_name;
        //     $short_name =substr($row->customer_name, 0, 10);
        //     echo '<br>';
        //     $getInfo = DB::selectOne("SELECT * FROM aaa_billing_cust_ac a WHERE a.udAcName LIKE '$short_name%'");
        //     if($getInfo){
        //         DB::update("UPDATE aaa_billing_cust_ac
        //             SET customer_id = ?, customer_name = ?, short_name = ?
        //             WHERE id = ? ", [$customer_id, $customer_name, $short_name, $getInfo->id]);
        //     }
        // }

        // return 2;





        if (!auth()->user()->can('Create Customer')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $acCustomers = [];
        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        // Customer GL Code
        $getCusHead = GlHead::where('gl_subject',strtoupper('Accounts Receivable'))->first();
        if($getCusHead){
            $glCodeCus = $getCusHead->gl_code;

            //get customer list from api - salaquzzaman @ 03-06-2024
            try{
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip.'/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $glCodeCus,
                    'companyNo' => $company_number,
                ]);

                if ($response->successful()) {
                    $responseData = $response->json();
                    if ($responseData && isset($responseData['accHeadDetailsInfos'])) {
                        $acCustomers = $responseData['accHeadDetailsInfos'];



                    //     $userData = array(
                    //         'NAME' => $this->Zaman
                    //         'ROLL' => $this->522
                    //    );
                    //    DB::table('users')->insert([$userData]);
                    }
                }
            }catch (\Exception $e) {
                // Log::error($e->getMessage());
                if($e->getMessage()){
                    return redirect()->route('dashboard')->with('error', 'API Connection Timeout');
                }
            }
        }

        return view('customer.create',compact('acCustomers'));
    }




    // public function store(Request $request)
    // {
    //     if (!auth()->user()->can('Create Customer')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }

    //     $validator = Validator::make($request->all(), [
    //         'customer_name' => 'required',
    //         'phone' => 'required',
    //         'billing_name' => 'required',
    //         'billing_phone' => 'required',
    //         'billing_email' => 'required',
    //         'account_name' => 'required',
    //         'account_phone' => 'required',
    //         'account_email' => 'required',
    //         'status' => 'required',
    //     ]);

    //     if ($validator->fails()) {
    //         return redirect()->route('customers.create')
    //             ->with('error', 'Missing required fields.');
    //     }

    //     $data = $request->all();
    //     Customer::create($data + ['created_by' => auth()->id()]);

    //     return redirect()->route('customers.index')
    //         ->with('success', 'Customer created successfully.');
    // }




    public function store(Request $request)
    {

        if (!auth()->user()->can('Create Customer')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $validator = Validator::make($request->all(), [
            'customer_name' => 'required',
            // 'phone' => 'required|regex:/^01[3-9][0-9]{8}$/',
            'billing_name' => 'required',
            // 'billing_phone' => 'required|regex:/^01[3-9][0-9]{8}$/',
            'billing_email' => 'required|email',
            'status' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('customers.create')
                ->withErrors($validator)
                ->withInput()
                ->with('error', 'Missing required fields.');
        }

        $data = $request->all();
        $info = Customer::create($data + ['created_by' => auth()->id()]);

        if(trim($request->attention_person)!=''){
            if($info){
                $attention                   = new AttentionPerson;
                $attention->customer_id      = $info->id;
                $attention->attention_name   = $request->attention_person;
                $attention->status           = 'Active';
                $attention->created_by       = auth()->id();
                $attention->updated_by       = auth()->id();
                if($attention->save()){
                    $cuInfo = Customer::find($info->id);
                    $cuInfo->attention_person = $attention->id;
                    $cuInfo->save();
                }
            }
        }

        return redirect()->route('customers.index')
            ->with('success', 'Customer created successfully.');
    }



    public function show(Customer $customer)
    {
        if (!auth()->user()->can('View Customer')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        return view('customer.show', compact('customer'));
    }

    public function edit(Customer $customer)
    {
        if (!auth()->user()->can('Edit Customer')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $acCustomers = [];
        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        // Customer GL Code
        $getCusHead = GlHead::where('gl_subject',strtoupper('Accounts Receivable'))->first();
        if($getCusHead){
            $glCodeCus = $getCusHead->gl_code;

            //get customer list from api - salaquzzaman @ 03-06-2024
            try{
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip.'/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $glCodeCus,
                    'companyNo' => $company_number,
                ]);

                if ($response->successful()) {
                    $responseData = $response->json();
                    if ($responseData && isset($responseData['accHeadDetailsInfos'])) {
                        $acCustomers = $responseData['accHeadDetailsInfos'];
                    }
                }
            }catch (\Exception $e) {
                // Log::error($e->getMessage());
                if($e->getMessage()){
                    return redirect()->route('dashboard')->with('error', 'API Connection Timeout');
                }
            }
        }
        $attentions = AttentionPerson::select('id','attention_name')
            ->where('customer_id',$customer->id)->orderBy('attention_name', 'asc')->get();

        return view('customer.edit', compact('customer','acCustomers','attentions'));
    }



    // public function update(Request $request, Customer $customer)
    // {
    //     if (!auth()->user()->can('Edit Customer')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }

    //     $validator = Validator::make($request->all(), [
    //         'customer_name' => 'required',
    //         'phone' => 'required',
    //         'billing_name' => 'required',
    //         'billing_phone' => 'required',
    //         'billing_email' => 'required',
    //         'account_name' => 'required',
    //         'account_phone' => 'required',
    //         'account_email' => 'required',
    //         'status' => 'required',
    //     ]);

    //     if ($validator->fails()) {
    //         return redirect()->route('customers.edit', $customer)
    //             ->with('error', 'Missing required fields.');
    //     }

    //     $customer->update($request->all());
    //     return redirect()->route('customers.index')
    //         ->with('success', 'Customer updated successfully.');

    // }




    public function update(Request $request, Customer $customer)
    {

        if (!auth()->user()->can('Edit Customer')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $validator = Validator::make($request->all(), [
            'customer_name' => 'required',
            // 'phone' => 'required|regex:/^01[3-9][0-9]{8}$/',
            'billing_name' => 'required',
            // 'billing_phone' => 'required|regex:/^01[3-9][0-9]{8}$/',
            'billing_email' => 'required',
            'status' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('customers.edit', $customer)
                ->with('error', 'Missing required fields.');
        }

        $customer->update($request->all());
        return redirect()->route('customers.index')
            ->with('success', 'Customer updated successfully.');

    }

    public function destroy(Customer $customer)
    {
        if (!auth()->user()->can('Delete Customer')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $bills = Bill::where('customer_id',$customer->id)->first();
        $billProcesses = BillProcess::where('customer_id',$customer->id)->first();

        if(empty($bills) && empty($billProcesses)){

            // $token = session('api_token');
            // $api_ip = env("API_IP");
            // $company_number = env("COMPANY_NUMBER");

            // // delete from customer api - salaquzzaman @ 10-06-2024
            // try{
            //     $response = Http::withHeaders([
            //         'Authorization' => 'Bearer ' . $token,
            //     ])->delete($api_ip.'/api/v1/chartOfAcc/deleteCoaInfo/'.$autoAcNo);

            //     if ($response->successful()) {
            //         $responseData = $response->json();
            //         if ($responseData && $responseData['message']=='Success') {
            //             $customer->delete();
            //             return redirect()->route('customers.index')
            //                 ->with('success', 'Customer deleted successfully.');
            //         }else{
            //             return redirect()->route('customers.index')
            //                 ->with('error', 'This customer already have transaction.');
            //         }
            //     }
            // }catch (\Exception $e) {
            //     // Log::error($e->getMessage());
            // }
            $customer->delete();
            AttentionPerson::where('customer_id',$customer->id)->delete();
            return redirect()->route('customers.index')
                ->with('success', 'Customer deleted successfully.');
        }else{
            return redirect()->route('customers.index')
                ->with('error', 'Customer delete not possible, have bills.');
        }

    }

    public function checkAccountCustomer($id,$autoAcNo)
    {
        $id = (int)$id;
        if($id>0){ //update
            $customer = Customer::where('autoAcNo',$autoAcNo)->where('id','!=',$id)->get();
        }else{ //create
            $customer = Customer::where('autoAcNo',$autoAcNo)->get();
        }
        if(count($customer)>0){
            echo 2;
        }else{
            echo 1;
        }
    }

    public function addNewAttention(Request $request)
    {
        $customer_id = $request->customer_id;
        $name = trim($request->new_attention_person);
        if($name==''){
            return response()->json(['status' => 1]); // empty
        }else{
            $checkOld = AttentionPerson::select('id')->where('customer_id',$customer_id)->where('attention_name',$name)->first();
            if($checkOld){
                return response()->json(['status' => 2]); // exist
            }else{
                $attention                   = new AttentionPerson;
                $attention->customer_id      = $customer_id;
                $attention->attention_name   = $name;
                $attention->status           = 'Active';
                $attention->created_by       = auth()->id();
                $attention->updated_by       = auth()->id();

                if ($attention->save()) {

                    $selectedID = $attention->id;
                    $list = AttentionPerson::select('id','attention_name')
                        ->where('customer_id',$customer_id)
                        ->orderBy('attention_name', 'asc')->get();

                    $html='<option value="">--Select Attention Person--</option>';
                    foreach($list as $row){
                        $selected = '';
                        if($selectedID==$row->id){
                            $selected = 'selected';
                        }
                        $html.='<option value="'.$row->id.'" '.$selected.'>'.$row->attention_name.'</option>';
                    }

                    return response()->json([
                        'status' => 3,
                        'dropdown' => $html
                    ]);
                }
            }
        }

    }

    public function getAttentionList($autoAC){
        $custInfo = Customer::select('id','attention_person')->where('autoAcNo',$autoAC)->first();
        $selectedID = $custInfo->attention_person;
        $list = AttentionPerson::select('id','attention_name')
            ->where('customer_id',$custInfo->id)
            ->orderBy('attention_name', 'asc')->get();

        $html='<option value="">--Select Attention Person--</option>';
        foreach($list as $row){
            $selected = '';
            if($selectedID==$row->id){
                $selected = 'selected';
            }
            $html.='<option value="'.$row->id.'" '.$selected.'>'.$row->attention_name.'</option>';
        }
        return $html;
    }

    public function customerNameFixing()
    {
        $customers = Customer::orderBy('customer_name')->get();

        return view('customer.customer-name-fixing', compact('customers'));
    }

    public function customerNameFixingUpdate(Request $request)
    {
        if (!$request->has('selected_customers')) {
            return back()->with('error', 'No customers selected.');
        }

        foreach ($request->selected_customers as $customerId) {

            $newName = $request->customer_new_name[$customerId] ?? null;

            if ($newName) {
                Customer::where('id', $customerId)->update([
                    'customer_name' => $newName
                ]);
            }
        }

        return back()->with('success', 'Selected customer names updated successfully.');
    }
    

}
