<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DepositoryBank;
use Illuminate\Support\Facades\Validator;

class DepositoryBankController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Manage Setup')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }
        
    //     $depositoryBanks = DepositoryBank::all();
    //     return view('depositoryBank.index', compact('depositoryBanks'));
    // }


    public function index(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);

        $depositoryBanks = DepositoryBank::paginate($perPage);

        return view('depositoryBank.index', compact('depositoryBanks', 'perPage'));
    }


    public function create()
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        return view('depositoryBank.create');
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'bank_id' => 'required',
            'bank_name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('depository-bank.index')
                         ->with('error', 'Missing required fields.');
        }

        DepositoryBank::create($request->all() + ['created_by' => auth()->id()]);

        return redirect()->route('depository-bank.index')
                         ->with('success', 'Depository Bank created successfully.');
    }

    public function edit(DepositoryBank $depositoryBank)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        return view('depositoryBank.edit', compact('depositoryBank'));
    }

    public function update(Request $request, DepositoryBank $depositoryBank)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'bank_id' => 'required',
            'bank_name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('depository-bank.index')
                         ->with('error', 'Missing required fields.');
        }

        $depositoryBank->update($request->all());

        return redirect()->route('depository-bank.index')
                         ->with('success', 'Depository Bank updated successfully.');
    }

    public function destroy(DepositoryBank $depositoryBank)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        
        $depositoryBank->delete();

        return redirect()->route('depository-bank.index')
                         ->with('success', 'Depository Bank deleted successfully.');
    }
}
