<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\GlHead;
use Illuminate\Support\Facades\Validator;

class GlHeadController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Manage Setup')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }
        

    //     $glHeads = GlHead::all();
    //     return view('glHead.index', compact('glHeads'));
    // }

    public function index(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);

        $glHeads = GlHead::paginate($perPage);

        return view('glHead.index', compact('glHeads', 'perPage'));
    }

    public function create()
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        return view('glHead.create');
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'gl_code' => 'required',
            'gl_subject' => 'required',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('gl-head.index')
                         ->with('error', 'Missing required fields.');
        }

        GlHead::create($request->all());

        return redirect()->route('gl-head.index')
                         ->with('success', 'GL Head created successfully.');
                         
    }

    public function edit(GlHead $glHead)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        return view('glHead.edit', compact('glHead'));
    }

    public function update(Request $request, GlHead $glHead)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'gl_code' => 'required',
            'gl_subject' => 'required',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('gl-head.index')
                         ->with('error', 'Missing required fields.');
        }

        $glHead->update($request->all());

        return redirect()->route('gl-head.index')
                         ->with('success', 'GL Head updated successfully.');
    }

    public function destroy(GlHead $glHead)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        $glHead->delete();

        return redirect()->route('gl-head.index')
                         ->with('success', 'GL Head deleted successfully.');
    }
}
