<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Department;
use App\Models\Bill;
use App\Models\BillProcess;
use App\Models\BillSubject;
use App\Models\GlHead;
use App\Models\User;
use App\Models\Settings;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class InstantInvoiceController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Show Instant Invoice')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }

    //     $bills = BillProcess::where('bill_type','One Time')->orderBy('id','desc')->get();
    //     return view('instant-invoice.index', compact('bills'));
    // } 


    public function index(Request $request)
    {
        if (!auth()->user()->can('Show Instant Invoice')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);

        $bills = BillProcess::where('bill_type', 'One Time')->orderBy('id', 'desc')->paginate($perPage);

        return view('instant-invoice.index', compact('bills', 'perPage'));
    }



    public function create()
    {
        if (!auth()->user()->can('Create Instant Invoice')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $customers = [];
        $depts = [];
        $subjects = BillSubject::orderBy('bill_subject')->get();

        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        // Customer GL Code
        $getCusHead = GlHead::where('gl_subject',strtoupper('Accounts Receivable'))->first();
        if($getCusHead){
            $glCodeCus = $getCusHead->gl_code;

            //get customer list from api - salaquzzaman @ 03-06-2024
            try{
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip.'/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $glCodeCus,
                    'companyNo' => $company_number,
                ]);

                if ($response->successful()) {
                    $responseData = $response->json();
                    if ($responseData && isset($responseData['accHeadDetailsInfos'])) {
                        $customers = $responseData['accHeadDetailsInfos'];
                    }
                }
            }catch (\Exception $e) {
                // Log::error($e->getMessage());
            }
        }

        //get department list from api - salaquzzaman @ 05-06-2024
        try{
            $response2 = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/departments/all');

            if ($response2->successful()) {
                $responseData2 = $response2->json();
                if ($responseData2) {
                    $depts = $responseData2;
                }
            }
        }catch (\Exception $e) {
            // Log::error($e->getMessage());
        }

        return view('instant-invoice.create', compact('customers','depts','subjects'));
    }
    public function store(Request $request)
    {
        if (!auth()->user()->can('Create Instant Invoice')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $validator = Validator::make($request->all(), [
            'customer_id' => 'required',
        ]);
        if ($validator->fails()) {
            return redirect()->route('instantInvoice.index')
                         ->with('error', 'Missing required fields.');
        }

        $qty = $request->qty;
        if(count($qty)>0){

            // Check customer available or not
            $fndCustomer = Customer::where('autoAcNo',$request->customer_id)->first();
            if($fndCustomer){
                $custPKID = $fndCustomer->id;
                $autoAcNo = $fndCustomer->autoAcNo;
            }else{

                // Customer create to db
                $customer_name = $request->customerName;
                $email = Settings::genRandString(6).'@example.com';
                $autoAcNo = $request->customer_id;
                $phoneNo = '0'.mt_rand(001111,999999);
                $cusInfo = [
                    'customer_name' => $customer_name,
                    'phone' => $phoneNo,
                    'billing_name' => $customer_name,
                    'billing_phone' => $phoneNo,
                    'billing_email' => $email,
                    'account_name' => $customer_name.' A/C',
                    'account_phone' => $phoneNo,
                    'account_email' => $email,
                    'status' => 'Active',
                    'autoAcNo' => $autoAcNo,
                ];

                $newCust = Customer::create($cusInfo + ['created_by' => auth()->id()]);
                $custPKID = $newCust->id;
            }

            // Proceed to bill create
            $k = 0;
            foreach($qty as $quantity){

                if($request->vat_status==1){
                    $total_amount_vat = $request->total_value[$k];
                }
                else{
                    $total_amount_vat = $request->total_price[$k];
                }

                // Bill Table
                $bill = Bill::create([
                    'customer_id' => $custPKID,
                    'particulars' => $request->particulars[$k],
                    'qty' => $request->qty[$k],
                    'unit_price_vat' => $request->unit_price[$k],
                    'total_amount' => $request->total_price[$k],
                    'total_amount_vat' => $total_amount_vat,
                    'bill_subject_id' => $request->subject_id,
                    'department_id' => $request->department_id,

                    // don't delete ref date, one time bill voucher will use this while approving.
                    'ref_date' => $request->invoice_date, // ref_date
                    'bill_type' => 'One Time',
                    'vat_percent' => $request->vat_rate[$k],
                    'vat_status' => $request->vat_status,
                    'status' => 'Active',
                    'created_by' => Auth::user()->id,
                ]);

                if($bill->id){

                    // Bill Process Table
                    BillProcess::create([
                        'bill_id' => $bill->id,
                        'invoice_no' => Settings::invoiceFormat($bill->id),
                        'customer_id' => $custPKID,
                        'particulars' => $request->particulars[$k],
                        'qty' => $request->qty[$k],
                        'unit_price_vat' => $request->unit_price[$k],
                        'total_amount' => $request->total_price[$k],
                        'total_amount_vat' => $total_amount_vat,
                        'bill_subject_id' => $request->subject_id,
                        'department_id' => $request->department_id,
                        'bill_type' => 'One Time',
                        'vat_percent' => $request->vat_rate[$k],
                        'vat_status' => $request->vat_status,
                        // 'ref_no' => null,
                        'ref_date' => $request->invoice_date,
                        'invoice_date' => $request->invoice_date,
                        'payment_status' => 'Unpaid',
                        'year' => $request->year,
                        'month' => $request->month,
                        'remarks' => $request->remarks,
                        'status' => 'Active',
                        'processedBy' => Auth::user()->id,
                    ]);

                }

                $k = $k + 1;
            }

            //update department_id to customer
            Customer::find($custPKID)->update(['divCode' => $request->department_id]);
        }

        return redirect()->route('instantInvoice.index')
                         ->with('success', 'Invoice created successfully.');
    }

    public function show($billID)
    {
        if (!auth()->user()->can('Show Instant Invoice')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $departments = [];
        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        //get department list from api - salaquzzaman @ 05-06-2024
        try{
            $response2 = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/departments/all');

            if ($response2->successful()) {
                $responseData2 = $response2->json();
                if ($responseData2) {
                    $departments = json_encode($responseData2);
                }
            }
        }catch (\Exception $e) {
            // Log::error($e->getMessage());
        }

        $bill = BillProcess::find($billID);
        return view('instant-invoice.show', compact('bill','departments'));
    }


}
