<?php

namespace App\Http\Controllers;

use App\Models\VatSetup;
use Illuminate\Http\Request;

class VatController extends Controller
{
    // public function index()
    // {
    //     $vats =VatSetup::all();
    //     return view('vat.inedx', compact('vats'));
    // }


    public function index(Request $request)
    {

        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        $perPage = $request->input('per_page', 25);
        $vats = VatSetup::paginate($perPage);

        return view('vat.inedx', compact('vats', 'perPage'));
    }

    public function create()
    {
        return view('vat.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'vat' => 'required|numeric|min:0',
        ]);

        VatSetup::create([
            'vat'=>$request->vat,

        ]);

        return redirect()->back()->with('success', 'VAT successfully created');
    }
    public function view($id)
    {
        $vatsview = VatSetup::findOrFail($id);
        return view('vat.view', compact('vatsview'));
    }
    public function edit($id)
    {
        $vatsedit = VatSetup::findOrFail($id);
        return view('vat.edit', compact('vatsedit'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'vat' => 'required|numeric|min:0',
        ]);

        $vat = VatSetup::findOrFail($id);
        
        $vat->update([
            'vat' => $request->vat,
        ]);

        return redirect()->route('vat.index')->with('success', 'VAT successfully updated');
    }

    public function delete($id)
    {
        $vatsd = VatSetup::findOrFail($id);
        $vatsd->delete();
        
        return redirect()->route('vat.index')->with('success', 'VAT successfully deletd');
    }


}
