<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\BillProcess;

class ProcessedBill extends Mailable
{
    use Queueable, SerializesModels;

    public $billProcess;
    public $settings;

    /**
     * Create a new message instance.
     *
     * @param BillProcess $billProcess
     * @param array $settings
     */
    public function __construct(BillProcess $billProcess, array $settings)
    {
        $this->billProcess = $billProcess;
        $this->settings = $settings;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'New Bill',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.processed_bill',
            with: [
                'billProcess' => $this->billProcess,
                'settings' => $this->settings,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
