<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BillRevision extends Model
{
    use HasFactory;

    protected $table = 'billing_bill_revisions';

    protected $primaryKey = 'id';

    protected $fillable = [
        'bill_id',
        'revision_no',
        'project_id',
        'customer_id',
        'bill_subject_id',
        'particulars',
        'currency',
        'currency_rate',
        'qty',
        'unit_price_vat',
        'unit_total',
        'conv_unit_total',
        'total_amount',
        'convertion_total_amount',
        'vat_type',
        'vat_status',
        'vat_percent',
        'vat_amount',
        'conv_vat_amount',
        'total_amount_vat',
        'convertion_total_amount_vat',
        'bin_number',
        'milestone',
        'ref_no',
        'ref_date',
        'installation_date',
        'activation_date',
        'start_date',
        'end_date',
        'attention_id',
        'attention_person',
        'department_id',
        'billDivName',
        'bill_group',
        'bill_type',
        'hs_code',
        'payment_type',
        'yearly_increase_percent',
        'increase_period',
        'increase_start_date',
        'status',
        'vat_refund',
        'order_sl_no',
        'bill_note',
        'workorder_file',
        'instalation_file',
        'deliverychallan_file',
        'approval',
        'approved_by',
        'awaiting_approved_by',
        'department_head',
        'bill_editor_id',
        'bill_edited',
        'delete_flag',
        'reject_note',
        'created_by',
        'bill_slno_x',
        'bill_no_x',
        'bill_old',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function billSubject()
    {
        return $this->belongsTo(BillSubject::class);
    }

}

