<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Collection extends Model
{
    use HasFactory;

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function customerBank()
    {
        return $this->belongsTo(CustomerBank::class,'bank_id');
    }

    public function depositoryBank()
    {
        return $this->belongsTo(DepositoryBank::class,'dep_bank_id');
    }

    public function collectionDetails()
    {
        return $this->belongsTo(CollectionChd::class,'collection_id');
    }
}
