<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $table='billing_customers';

    protected $fillable = [
        'customer_name',
        'address',
        'phone',
        'attention_person',
        'bin_no',
        'billing_name',
        'billing_phone',
        'billing_email',
        'account_name',
        'account_phone',
        'account_email',
        'vat_reg_no',
        'vat_code',
        'advance_adjust',
        'autoAcNo',
        'divCode',
        'status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
    ];

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function bills()
    {
        return $this->hasMany(Bill::class);
    }

    public function invoices()
    {
        return $this->hasMany(BillProcess::class);
    }
    public function advancedcollection()
    {
        return $this->hasMany(AdvancedCollection::class);
    }
    public function attentionPerson()
    {
        return $this->belongsTo(AttentionPerson::class, 'attention_person');
    }

}
