<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerBank extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'bank_id',
        'bank_name',
        'address',
        'phone',
        'email',
        'fax',
        'created_by',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    
}
