<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

use Illuminate\Support\Facades\DB;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

    protected $guard_name = 'web';
    protected $appends = ['user_image'];

    protected $fillable = [
        'name',
        'employee_id',
        'email',
        'phone',
        'password',
        'avatar',
        'type',
        'address',
        'created_by',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public static function getpermissionGroups()
     {
         $permission_groups = DB::table('permissions')->where('group_name', '!=', null)
             ->select('group_name as name')
             ->groupBy('group_name')
             ->get();
         return $permission_groups;
     }

     public static function getpermissionsByGroupName($group_name)
     {
         $permissions = DB::table('permissions')
             ->select('name', 'id')
             ->where('group_name', $group_name)
             ->get();
         return $permissions;
     }

     public static function roleHasPermissions($role, $permissions)
     {
         $hasPermission = true;
         foreach ($permissions as $permission) {
             if (!$role->hasPermissionTo($permission->name)) {
                 $hasPermission = false;
                 return $hasPermission;
             }
         }
         return $hasPermission;
     }

    public function getUserImageAttribute()
    {
        $user_avatar = asset('images/user.png');
        $avatar = trim($this->avatar);
        $avatarPath = 'storage/avatar/' . $avatar;
        if($avatar!='' && file_exists(public_path($avatarPath))){
            $user_avatar = asset($avatarPath);
        }
        return $user_avatar;
    }

}
