<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('depository_banks', function (Blueprint $table) {
            $table->id();
            $table->integer('bank_id')->default(0);
            $table->string('holder_name')->nullable();
            $table->string('bank_name');
            $table->string('divCode');
            $table->float('opening_balance', 15, 2)->default('0.00');
            $table->text('address')->nullable();
            $table->string('phone');
            $table->string('email')->nullable();
            $table->string('fax')->nullable();
            $table->bigInteger('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('depository_banks');
    }
};
