<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer_banks', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('customer_id');
            $table->string('bank_id');
            $table->string('bank_name');
            $table->text('address');
            $table->string('phone');
            $table->string('email');
            $table->string('fax')->nullable();
            $table->bigInteger('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_banks');
    }
};
