<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('advanced_collections', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('customer');
            $table->decimal('amount', 10, 2);
            $table->bigInteger('bank');
            $table->string('instrument_mode')->nullable();
            $table->string('department_id')->nullable();
            $table->string('depDivName')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('advanced_collections');
    }
};
