@php
    $settings = App\Models\Settings::get_settings();
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Login | {{ $settings['app_name'] }} </title>

    @if (!empty($settings['company_favicon']))
        <link rel="shortcut icon" href="{{ asset('storage/logo/' . $settings['company_favicon']) }}" type="image/x-icon">
    @endif

    <!-- Bootstrap -->
    <link href="{{ asset('vendors/bootstrap/dist/css/bootstrap.min.css') }}" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="{{ asset('vendors/font-awesome/css/font-awesome.min.css') }}" rel="stylesheet">
    <!-- NProgress -->
    <link href="{{ asset('vendors/nprogress/nprogress.css') }}" rel="stylesheet">
    <!-- Animate.css -->
    <link href="{{ asset('vendors/animate.css/animate.min.css') }}" rel="stylesheet">

    <!-- Custom Theme Style -->
    <link href="{{ asset('build/css/custom.min.css') }}" rel="stylesheet">

    <style>
        .login{
            /* background: #F3F5F9; */
            /* background: #3C8DBC; */
            background: linear-gradient(90deg, #C7C5F4, #776BCC);
        }
        .login_content{
            /* box-shadow: 0 6px 30px rgba(182, 186, 203, 0.3); */
            box-shadow: 0px 0px 24px #5C5696;
            background-color: #fff;
            transition: box-shadow 0.2s ease-in-out;
            padding: 10px 25px;
            /* border-radius: 10px; */
            border-radius: 5px;
        }
        .login_content form input[type="text"], .login_content form input[type="email"],
        .login_content form input[type="password"] {
            -webkit-box-shadow: initial;
            box-shadow: initial;
            border:1px solid #ced4da;
            border-radius: 5px;
        }
        .login_wrapper{
            max-width: 380px;
        }
        .login_content h1{
            color: #145388;
        }
        .invalid-feedback{
            font-size: 90%;
            text-align: center;
        }
        .submit{
            width: 100%;
            margin-top: 10px;
            border-radius: 5px;
            background: #145388;
            border: 1px solid #145388;
            padding: 7px;
        }
        label{
            color: #145388;
            font-weight: bold;
        }
    </style>
</head>

<body class="login">
    <div>
        <div class="login_wrapper">
            <div class="animate form login_form">
                <section class="login_content">
                    <img width="90%"
                        src="{{ !empty($settings['company_logo_dark']) ? asset('storage/logo/' . $settings['company_logo_dark']) : asset('images/logo_placeholder.png') }}"
                        alt="logo">
                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <h1 style="font-size: 19px;letter-spacing:2px;margin-bottom:20px">Billing Panel</h1>
                        @if (session('auth_error'))
                            <div class="alert alert-danger" style="text-shadow: 0 0 transparent;">
                                {{ session('auth_error') }}
                            </div>
                        @endif
                        <div class="text-left">
                            <label for="email">Email:</label>
                            <input id="email" type="email"
                                class="form-control @error('email') is-invalid @enderror" name="email"
                                value="{{ old('email') }}" required autocomplete="email" autofocus>
                        </div>

                        <div class="text-left">
                            <label for="password">Password:</label>
                            <input id="password" type="password"
                                class="form-control @error('password') is-invalid @enderror" name="password" required
                                autocomplete="current-password">



                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        @if ($errors->has('email'))
                            <div class="text-left">
                                <span class="invalid-feedback mt-0" role="alert" style="display:block;">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            </div>
                        @endif

                        <div class="mt-3">
                            <button class="btn btn-primary submit" type="submit">Log in</button>
                        </div>

                        <div class="clearfix"></div>

                        {{-- <div class="separator">

                            <div class="clearfix"></div>
                            <br />

                        </div> --}}
                    </form>
                </section>
                <div style="padding-top: 30px;text-align:center; color:#eee">
                    <p>© {{ $settings['company_name'] }} {{ date('Y') }} | All Rights Reserved.</p>
                </div>
            </div>


        </div>
    </div>
</body>

</html>
