@extends('layouts.app')

@section('title')
    Bill Process
@endsection

@section('content')
    <form id="processForm">
        @csrf
        <div class="row d-flex align-items-center mb-3">
            <div class="col-md-4">
                <h4 class="text-primary mb-0">Bill Process</h4>
            </div>
            <div class="col-md-4">
                <h5 class="mb-0 text-info text-center">{{ $billfilters->month }}, {{ $billfilters->year }}</h5>
            </div>
            <div class="col-md-4 text-right">
                @if (count($bills) > 0)
                    @can('Process Bill')
                        <button type="submit" class="btn btn-primary process-btn d-none">Process Bills</button>
                    @endcan
                @endif
            </div>
        </div>

        <div class="row table-form">
            <div id="totalBillCount" style="width: 100%;text-align: center;color: #1ca88a;font-weight: bold;font-size:16px"></div>
            <div style="width: 100%;text-align: center;color: #000;font-weight: bold;margin-bottom:12px;">
                Net Amount(BDT): <span class="gTotal">0</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                VAT Amount(BDT): <span class="gVAT">0</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                Total Amount(BDT): <span class="gTotalWithVAT">0</span>
            </div>
            <div style="overflow-x: auto; width: 100%;">
            <table class="table table-striped table-bordered process-table" style="width:100%;">
                <thead>
                    <tr>
                        <th class="text-center"><input type="checkbox" class="custom-checkbox" id="select-all" /><label
                                for="select-all">
                            </label></th>
                        <th>Sl</th>
                        <th>Bill No</th>
                        <th>Customer</th>
                        <th>Department</th>
                        <th>Bill Subject<br>& Group</th>
                        {{-- <th>Bill Group</th> --}}
                        {{-- <th>Qty</th>
                        <th>Unit Price</th> --}}
                        <th>Currency<br>& Rate</th>
                        <th>Net Amount</th>
                        <th>VAT Amount</th>
                        <th>Total Amount</th>
                        <th>Bill Type</th>
                        {{-- <th style="width:90px !important;">Action</th> --}}
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($bills as $row)
                        <tr>
                            <td class="text-center">
                                <input type="checkbox" class="custom-checkbox checkitem" id="selected_bills_{{ $row->id }}"
                                    name="selected_bills[]" value="{{ $row->id }}" /><label
                                    for="selected_bills_{{ $row->id }}"></label>
                                {{-- <input type="hidden" name="customer_ids[{{ $row->id }}]" value="{{ $row->customer_id }}" /> --}}

                                {{-- <input type="hidden" class="convTotal" value="{{ $row->convertion_total_amount }}">
                                <input type="hidden" class="convTotalVAT" value="{{ $row->conv_vat_amount }}">
                                <input type="hidden" class="convTotalWithVAT" value="{{ $row->convertion_total_amount_vat }}"> --}}

                                <div style="display: none">
                                    <span class="convTotal">{{ $row->convertion_total_amount }}</span>
                                    <span class="convTotalVAT">{{ $row->conv_vat_amount }}</span>
                                    <span class="convTotalWithVAT">{{ $row->convertion_total_amount_vat }}</span>
                                </div>

                            </td>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $row->id ? str_pad($row->id, 5, '0', STR_PAD_LEFT) : '-' }}</td>
                            {{-- <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td> --}}
                            <td>{{ $row->customer->customer_name ?? '' }}</td>
                            <td>{{ $row->billDivName }}</td>
                            <td>
                                @if(!empty($row->bill_subject_id) && !empty($row->billSubject))
                                {{$row->billSubject->bill_subject}}
                                @endif
                                <br>
                                Group: {{ $row->bill_group }}
                            </td>
                            {{-- <td>{{ $row->bill_group }}</td> --}}
                            {{-- <td class="text-right">{{ $row->qty }}</td>
                            <td class="text-right">{{ \App\Models\Settings::priceFormat($row->unit_price_vat) }}</td> --}}
                            <td>{{ $row->currency }} ({{ priceFormat($row->currency_rate ?? 0) }})</td>
                            <td class="text-right">{{ priceFormat($row->convertion_total_amount) }}</td>
                            <td class="text-right">{{ priceFormat($row->conv_vat_amount ?? 0) }}</td>
                            <td class="text-right">{{ priceFormat($row->convertion_total_amount_vat ?? 0) }}</td>
                            <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                            <td>

                                {{-- @if($row->bill_old!=1)
                                @can('Edit Bill')
                                    <a href="{{ route('bills.edit', $row->id) }}" class="btn btn-warning btn-sm text-dark">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                @endcan
                                @endif --}}

                                <a data-size="xl" class="btn btn-success btn-sm text-white cursor-pointer"
                                    data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true"
                                    data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                    data-original-title="View"><i class="fa fa-eye"></i></a>

                                {{-- <a href="{{ route('unposting.invoice', ['id' => $row->id]) }}" target="_blank"
                                    class="btn btn-info btn-sm" style="padding: 3px 1px">Pre Invoice</a> --}}

                            </td>
                        </tr>
                    @endforeach
                    @if (count($bills) === 0)
                        <tr>
                            <td colspan="10" class="text-center">No Bills Found!</td>
                        </tr>
                    @endif
                </tbody>
            </table>
            </div>
        </div>

        <input type="hidden" name="bill_type" value="{{ $billfilters->bill_type }}">
        <input type="hidden" name="month" value="{{ $billfilters->month }}">
        <input type="hidden" name="year" value="{{ $billfilters->year }}">
        <input type="hidden" name="invoice_date" value="{{ $billfilters->invoice_date }}">
        <input type="hidden" name="remarks" value="{{ $billfilters->remarks }}">
        <input type="hidden" name="vat_refund" value="{{ $billfilters->vat_refund }}">

        <div class="row mt-3">
            <div class="col-md-12 text-center">
                @if (count($bills) > 0)
                    @can('Process Bill')
                        <button type="submit" class="btn btn-primary process-btn d-none">Process Bills</button>
                    @endcan
                @endif
            </div>
        </div>
    </form>
    <style>
        .process-table{
            font-size: 14px;
        }
        .process-table td{
            padding: 2px !important;
            border: 1px solid #d2d4d7 !important;
            font-size: 13.5px;
        }
    </style>
@endsection

@section('script')
    <script>
        $(document).ready(function() {

            $('#select-all').click(function() {
                $('input[name="selected_bills[]"]').prop('checked', this.checked);
                calcAmount();
            });

            $('.process-btn').click(function(event) {

                event.preventDefault();
                if ($('input[name="selected_bills[]"]:checked').length === 0) {
                    event.preventDefault();
                    show_toastr('error', 'No Bill Selected!');
                } else {

                    // confirm check
                    const swalWithBootstrapButtons = Swal.mixin({
                        customClass: {
                            confirmButton: "btn btn-success",
                            cancelButton: "btn btn-danger",
                        },
                        buttonsStyling: false,
                    });
                    swalWithBootstrapButtons
                        .fire({
                            title: "Are you sure to process?",
                            text: "",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonText: "Yes, Process it!",
                            cancelButtonText: "No, cancel!",
                            reverseButtons: true,
                        })
                        .then((result) => {
                            if (result.isConfirmed) {
                                $('.process-btn').html(
                                    '<span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span> Processing...'
                                );
                                $('.ajaxLoaderFormLoad').show();
                                $('.process-btn').addClass('d-none');
                                $(".table-form").css("pointer-events", "none");

                                $('#processForm').attr('method', 'post');
                                $('#processForm').attr('action', '{{ route('bill-process.store') }}');
                                $("#processForm").submit();

                            } else if (result.dismiss === Swal.DismissReason.cancel) {
                            }
                        });

                }

            });

            $('.checkitem').click(function(){
                calcAmount();
            });

            $('.process-btn').removeClass('d-none');

            $("#totalBillCount").html('Total Bills Found : ' + {{count($bills)}});

        });


        function calcAmount(){
            var grandConvTotal = 0;
            var grandConvTotalVAT = 0;
            var grandConvTotalWithVAT = 0;
            $('.checkitem').each(function( index ) {
                var closestRow = $(this).closest('tr');
                if (closestRow.find('.checkitem').prop('checked')) {
                    var convTotal = parseFloat(closestRow.find('.convTotal').text());
                    grandConvTotal = grandConvTotal + convTotal;

                    var convTotalVAT = parseFloat(closestRow.find('.convTotalVAT').text());
                    grandConvTotalVAT = grandConvTotalVAT + convTotalVAT;

                    var convTotalWithVAT = parseFloat(closestRow.find('.convTotalWithVAT').text());
                    grandConvTotalWithVAT = grandConvTotalWithVAT + convTotalWithVAT;
                }
            });
            $('.gTotal').text(grandConvTotal.toFixed(2));
            $('.gVAT').text(grandConvTotalVAT.toFixed(2));
            $('.gTotalWithVAT').text(grandConvTotalWithVAT.toFixed(2));

        }
    </script>
@endsection
