@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
Old Bill Process
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Old Bill Process </h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form id="reportForm" action="{{ route('bill-process-unposted.find') }}" method="POST" autocomplete="off">
                            @csrf
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="customer" class="form-label">Customer*</label>
                                                <select name="customer" id="customer" class="form-control select2 required">
                                                    <option value="">--Select customer--</option>
                                                    @foreach ($customers as $customer)
                                                        <option value="{{ $customer->id }}" data-extra="{{$customer->autoAcNo}}">
                                                            {{ $customer->customer_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="bill_type">Bill Type* :</label>
                                                <select id="bill_type" name="bill_type" class="form-control" required>
                                                    <option value="">--Select bill type--</option>
                                                    <option value="One Time">One Time</option>
                                                    <option value="Recurring Service">Recurring Service</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div><label for="month">Bill Month* (MM-YY) :</label></div>
                                                <div class="col-md-6" style="padding: 0">
                                                    <select id="month" name="month" class="form-control select2" onchange="setDate()" required>
                                                        <option value="January" {{(date('F')=='January')? 'selected':''}}>01</option>
                                                        <option value="February" {{(date('F')=='February')? 'selected':''}}>02</option>
                                                        <option value="March" {{(date('F')=='March')? 'selected':''}}>03</option>
                                                        <option value="April" {{(date('F')=='April')? 'selected':''}}>04</option>
                                                        <option value="May" {{(date('F')=='May')? 'selected':''}}>05</option>
                                                        <option value="June" {{(date('F')=='June')? 'selected':''}}>06</option>
                                                        <option value="July" {{(date('F')=='July')? 'selected':''}}>07</option>
                                                        <option value="August" {{(date('F')=='August')? 'selected':''}}>08</option>
                                                        <option value="September" {{(date('F')=='September')? 'selected':''}}>09</option>
                                                        <option value="October" {{(date('F')=='October')? 'selected':''}}>10</option>
                                                        <option value="November" {{(date('F')=='November')? 'selected':''}}>11</option>
                                                        <option value="December" {{(date('F')=='December')? 'selected':''}}>12</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6" style="padding: 0">
                                                    <select id="year" name="year" class="form-control select2" onchange="setDate()" required>
                                                        @for ($year = 2000; $year <= date('Y'); $year++)
                                                            @if ($year == date('Y'))
                                                                <option value="{{ $year }}" selected>{{ $year }}</option>
                                                            @else
                                                                <option value="{{ $year }}">{{ $year }}</option>
                                                            @endif
                                                        @endfor
                                                    </select>
                                                </div>
                                                <div style="clear:both"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="row align-items-end">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="invoice_date">Invoice Date* :</label>

                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                                        name="invoice_date" id="invoice_date" placeholder="dd/mm/yyyy" value="{{date("t/m/Y")}}" autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>

                                                {{-- <input type="text" class="form-control" name="invoice_date" id="invoice_date" value="{{date("t/m/Y")}}" readonly> --}}
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="vat_refund">VAT Stamp* :</label>
                                                <select id="vat_refund" name="vat_refund" class="form-control">
                                                    <option value="1">Yes</option>
                                                    <option value="0">No</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="remarks">Remarks :</label>
                                                <input type="text" id="remarks" class="form-control" name="remarks">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block process-btn" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('bill-process-unposted') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script>
        $('#customer').change(function(){
            var selOption = $(this).children('option:selected');
            var autoAcNo = selOption.data('extra');
            if(autoAcNo==''){
                $('#customer').val('');
                show_toastr('error', 'Customer AutoAC No is not linked');
                return false;
            }
        });


        function setDate(){
            var monthName = $('#month').val();
            var year = $('#year').val();
            const lastDate = getLastDateOfMonth(year, monthName);
            // console.log(`The last date of ${monthName} ${year} is ${lastDate}.`);
            $('#invoice_date').val(lastDate+'/'+year);
        }

        function getMonthNumber(monthName) {
            const months = {
                "January": 1,
                "February": 2,
                "March": 3,
                "April": 4,
                "May": 5,
                "June": 6,
                "July": 7,
                "August": 8,
                "September": 9,
                "October": 10,
                "November": 11,
                "December": 12
            };
            return months[monthName] || -1; // Returns -1 if the month name is invalid
        }

        function getLastDateOfMonth(year, monthName) {
            const month = getMonthNumber(monthName);
            if (month === -1) {
                return "Invalid month name!";
            }
            // Month is 1-indexed here, so subtract 1 to get 0-indexed month
            var lastDate = new Date(year, month, 0).getDate();
            var monthNumFixed = String(month).padStart(2, '0');
            return lastDate+'/'+monthNumFixed;
        }
    </script>
    <script>
        $('.process-btn').click(function () {
            if($("#customer").val()==''){
                show_toastr('error', 'Please, select customer');
                return false;
            }
            const form = $('#reportForm')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            $('.ajaxLoaderFormLoad').show();
            form.submit();
        });
    </script>
@endsection
