<form id="billProcessForm" action="{{ route('single.bill.process', $bill->id) }}" method="POST">
    @csrf
<div class="modal-body">
    <div class="row">
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill No:</b></div>
            <p class="text-muted mb-3">{{ $bill->id ? str_pad($bill->id, 5, '0', STR_PAD_LEFT) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Customer:</b></div>
            <p class="text-muted mb-3">{{ $bill->customer ? $bill->customer->customer_name : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Particulars:</b></div>
            <p class="text-muted mb-3">{{ $bill->particulars ? $bill->particulars : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Currency:</b></div>
            <p class="text-muted mb-3">{{ $bill->currency ? $bill->currency : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Currency Rate:</b></div>
            <p class="text-muted mb-3">{{ $bill->currency_rate ? $bill->currency_rate : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Quantity:</b></div>
            <p class="text-muted mb-3">{{ $bill->qty ? $bill->qty : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Unit Price:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->unit_price_vat ? \App\Models\Settings::priceFormat($bill->unit_price_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Total Amount:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->total_amount ? \App\Models\Settings::priceFormat($bill->total_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Total Amount with VAT:</b></div>
            <p class="text-muted mb-3">{{ $bill->total_amount_vat ? \App\Models\Settings::priceFormat($bill->total_amount_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Convertion Total Amount:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->convertion_total_amount ? \App\Models\Settings::priceFormat($bill->convertion_total_amount_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Subject:</b></div>
            <p class="text-muted mb-3">{{ $bill->billSubject ? $bill->billSubject->bill_subject : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bin Number:</b></div>
            <p class="text-muted mb-3">{{ $bill->bin_number ? $bill->bin_number : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Refund:</b></div>
            <p class="text-muted mb-3">
                @if($bill->vat_refund == 1)
                    Yes
                @elseif($bill->vat_refund == 0)
                    No
                @else
                    -
                @endif
            </p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Ref No:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_no ? $bill->ref_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Ref Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_date ? $bill->ref_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Installation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->installation_date ? $bill->installation_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Activation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->activation_date ? $bill->activation_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Start Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->start_date ? $bill->start_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>End Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->end_date ? $bill->end_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Department:</b></div>
            <p class="text-muted mb-3">{{ $bill->billDivName ? $bill->billDivName : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Group:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_group ? $bill->bill_group : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Status:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_status == 1 ? 'Yes' : 'No' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Percent:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_percent !== null ? $bill->vat_percent . '%' : '-' }}</p>

        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Type:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_type ? $bill->bill_type : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <div><label for="month">Bill Month* (MM-YY) :</label></div>
                <div class="col-md-6" style="padding: 0">
                    <select id="month" name="month" class="form-control select2" onchange="setDate()" required>
                        <option value="January" {{(date('F')=='January')? 'selected':''}}>01</option>
                        <option value="February" {{(date('F')=='February')? 'selected':''}}>02</option>
                        <option value="March" {{(date('F')=='March')? 'selected':''}}>03</option>
                        <option value="April" {{(date('F')=='April')? 'selected':''}}>04</option>
                        <option value="May" {{(date('F')=='May')? 'selected':''}}>05</option>
                        <option value="June" {{(date('F')=='June')? 'selected':''}}>06</option>
                        <option value="July" {{(date('F')=='July')? 'selected':''}}>07</option>
                        <option value="August" {{(date('F')=='August')? 'selected':''}}>08</option>
                        <option value="September" {{(date('F')=='September')? 'selected':''}}>09</option>
                        <option value="October" {{(date('F')=='October')? 'selected':''}}>10</option>
                        <option value="November" {{(date('F')=='November')? 'selected':''}}>11</option>
                        <option value="December" {{(date('F')=='December')? 'selected':''}}>12</option>
                    </select>
                </div>
                <div class="col-md-6" style="padding: 0">
                    <select id="year" name="year" class="form-control select2" onchange="setDate()" required>
                        @for ($year = 2000; $year <= date('Y'); $year++)
                            @if ($year == date('Y'))
                                <option value="{{ $year }}" selected>{{ $year }}</option>
                            @else
                                <option value="{{ $year }}">{{ $year }}</option>
                            @endif
                        @endfor
                    </select>
                </div>
                <div style="clear:both"></div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label for="invoice_date">Invoice Date* :</label>
                <input type="text" class="form-control" name="invoice_date" id="invoice_date" value="{{date("t/m/Y")}}" readonly>
            </div>
        </div>
    </div>
</div>

<div class="modal-footer">
    <input type="hidden" name="successURL" id="successURL">
    <input type="submit" value="Submit" class="btn btn-success">
    <input type="button" value="Close" class="btn btn-danger" data-dismiss="modal">
</div>
</form>

<script>
    function setDate(){
        var monthName = $('#month').val();
        var year = $('#year').val();
        const lastDate = getLastDateOfMonth(year, monthName);
        // console.log(`The last date of ${monthName} ${year} is ${lastDate}.`);
        $('#invoice_date').val(lastDate+'/'+year);
    }

    function getMonthNumber(monthName) {
        const months = {
            "January": 1,
            "February": 2,
            "March": 3,
            "April": 4,
            "May": 5,
            "June": 6,
            "July": 7,
            "August": 8,
            "September": 9,
            "October": 10,
            "November": 11,
            "December": 12
        };
        return months[monthName] || -1; // Returns -1 if the month name is invalid
    }

    function getLastDateOfMonth(year, monthName) {
        const month = getMonthNumber(monthName);
        if (month === -1) {
            return "Invalid month name!";
        }
        // Month is 1-indexed here, so subtract 1 to get 0-indexed month
        var lastDate = new Date(year, month, 0).getDate();
        var monthNumFixed = String(month).padStart(2, '0');
        return lastDate+'/'+monthNumFixed;
    }
</script>
<script>
    $('#successURL').val(window.location.href);
</script>

