<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unposted Bill Report</title>
</head>
<body>

    <div class="row mt-2">
        <div class="col-md-12">
            <div style="color: #000;text-align: right;position: absolute;
                width: 100%;font-size: 17px !important;padding-right:10px;">
                Status : Unposted
            </div>
            <div class="row">
                <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                    <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                    <p style="font-size: 18px !important;">ACCOUNTS DEPARTMENT</p>
                    <p style="font-size: 18px !important;">UNPOSTED BILL LIST</p>
                    <p style="font-size: 18px !important;">CUSTOMER: {{$customerName}}</p>
                    <p style="font-size: 16px !important;">MONTH: <span style="text-transform: uppercase">{{$req_month}} {{$req_year}}</span></p>
                </div>
            </div>

            <div class="date-stamp">Printed Date: {{date('d/m/Y')}}</div>
            <table class="table table-bordered mt-2 invoice-table">
                <thead>
                    <tr>
                        <th>Sl</th>
                        <th>Bill No</th>
                        <th>Customer</th>
                        <th>Subject</th>
                        <th>Bill<br>Group</th>
                        <th>Qty</th>
                        <th>Month<br>Year</th>
                        <th>Unit Price</th>
                        <th>Currency<br>& Rate</th>
                        <th>Net Amount</th>
                        <th>VAT Amount</th>
                        <th>Total Amount</th>
                        <th>Bill Type</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach($result as $bill)

                        <tr>
                            <td class="text-center">{{ $loop->iteration }}</td>
                            <td class="text-center">{{ $bill["bill_no"] }}</td>
                            <td class="text-left">{{ $bill["customer_name"] }}</td>
                            <td class="text-left">{{ $bill["bill_subject"] }}</td>
                            <td class="text-center">{{ $bill["bill_group"] }}</td>
                            <td class="text-right">{{ $bill["qty"] }}</td>
                            <td class="text-left">{{ $bill["month_year"] }}</td>
                            <td class="text-right">{{ $bill["unit_price"] }}</td>
                            <td class="text-center">{{ $bill["currency"] }} ({{ $bill["currency_rate"] }})</td>
                            <td class="text-right">{{ $bill["total_amount"] }}</td>
                            <td class="text-right">{{ $bill["vat_amount"] }}</td>
                            <td class="text-right">{{ $bill["total_amount_vat"] }}</td>
                            <td class="text-center">{{ $bill["bill_type"] }}</td>
                        </tr>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>



    <style>
        .x_content{
            font-family: arial !important;
            color:#000 !important;
            font-size:13px;
        }
        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
        }
        .invoice-table, .invoice-table th, .invoice-table td {
            border: 0.5px solid #000 !important;
            border-collapse: collapse !important;
            font-size: 12px !important;
        }
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
            padding:2px !important;
            text-align: center;
        }
        .invoice-table td {
            padding:2px 4px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black{
            color: #000 !important;
            font-size: 13px !important;
        }
        /* p{
            margin-bottom: 1px
        } */
        .text-right{
            text-align: right;
        }
        .text-center{
            text-align: center;
        }
.p-2 {
    padding: .5rem !important;
}
.mb-2, .my-2 {
    margin-bottom: .5rem !important;
}
.pl-3, .px-3 {
    padding-left: 1rem !important;
}
.pr-3, .px-3 {
    padding-right: 1rem !important;
}
.pb-2, .py-2 {
    padding-bottom: .5rem !important;
}
.pt-2, .py-2 {
    padding-top: .5rem !important;
}
.mb-0, .my-0 {
    margin-bottom: 0 !important;
}
.mt-1, .my-1 {
    margin-top: .25rem !important;
}
.mt-2, .my-2 {
    margin-top: .5rem !important;
}
.mt-3, .my-3 {
    margin-top: 1rem !important;
}
.d-inline-block {
    display: inline-block !important;
}
.border {
    border: 1px solid #b9b6b6 !important;
}
h1, h2, h3, h4, h5, h6, p, .black {
    color: #000 !important;
    font-size: 13px !important;
}
.h6, h6 {
    font-size: 1rem;
}
.h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
    margin-bottom: .5rem;
    font-weight: 500;
    line-height: 1.2;
}
h1, h2, h3, h4, h5, h6 {
    margin-top: 0;
    margin-bottom: .5rem;
}
p{
    margin-top: 0px;
    margin-bottom: 2px;
}
.row{
    width:100%;
    /* border:1px solid green; */
}
.col-md-6{
    width:50%;
}
.float-left{
    float: left;
}
.clearfix{
    clear: both;
}
.customer-tag{
    padding: 5px 8px;
}
.date-stamp{
    font-size: 14px;
}
    </style>
</body>
</html>
