
@extends('layouts.app')

@section('title')
    Generate VAT Challan No
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-8">
            <div class=" mb-0 text-info" style="font-size:24px;">Generate VAT Challan No</div>
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('bill-process.vat-challan-list') }}" class="btn btn-primary">Back</a>
        </div>
    </div>

    @if(count($result) > 0)

    <form id="vatChallanForm">
        @csrf

    <div class="row form-data">
        <div class="col-md-4">
            <div class="form-group">
                <label for="bill_type">Ref No :</label>
                <input type="text" name="challan_ref_no" id="challanRefNo" value="{{ $nextChallanRefNo }}" class="form-control" required readonly>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="bill_type">Last VAT Challan No :</label>
                <input type="text" name="last_vat_challan_no" id="lastVatChallanNo" class="form-control" value="{{$lastChallanNo}}" readonly>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="invoice_date">VAT Challan Date* :</label>
                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                        name="challan_date" id="challanDate" placeholder="dd/mm/yyyy" value="{{date("d/m/Y")}}" autocomplete="off" required>
                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <label for="challan_remarks">Remarks :</label>
                <textarea id="challan_remarks" class="form-control" name="challan_remarks" style="height:40px;"></textarea>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel rounded table-form" style="padding: 5px">

                <div class="row mt-2">
                    <div class="col-md-12">

                        <div style="text-align: right">
                            Check All - <input type="checkbox" class="checkInvoiceAll" name="checkInvoiceAll" value="" id="checkInvoiceAll">
                        </div>

                        <table class="table table-bordered mt-1 invoice-table">
                            <thead>
                                <tr>
                                    <th>Customer</th>
                                    <th>Particulars</th>
                                    <th>Invoice<br>No</th>
                                    <th>Invoice<br>Date</th>
                                    <th>Net<br>Amount</th>
                                    <th>VAT<br>Amount</th>
                                    <th>Total<br>Amount</th>
                                    <th style="width:50px">Stamp VAT No.</nobr></th>
                                    <th><nobr>VAT Challan No.</nobr></th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $grand_total_amount = 0;
                                    $grand_vat_amount = 0;
                                    $grand_total_amount_vat = 0;
                                @endphp
                                @foreach ($result as $customerId => $data)
                                    @foreach ($data['rows'] as $row)
                                        <tr>
                                            <td>{{ $data['customer_name'] }}</td>
                                            <td>{{ $row->bill_subject_desc }}</td>
                                            <td>{{ $row->invoice_no }}</td>
                                            <td>{{ $row->invoice_date }}</td>
                                            <td class="text-right">{{ priceFormat($row->total_amount) }}</td>
                                            <td class="text-right">{{ priceFormat($row->vat_amount) }}</td>
                                            <td class="text-right">{{ priceFormat($row->total_amount_vat) }}</td>
                                            <td style="text-align: center; vertical-align: middle;">
                                                <input type="checkbox" class="checkInvoice" name="checkInvoice[]" value="{{$row->invoice_no}}">
                                            </td>
                                            <td class="challanSerial"></td>
                                        </tr>
                                    @endforeach
                                @endforeach
                            </tbody>
                        </table>


                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12 bottom-bar d-none" style="text-align: center">
        <a href="{{ route('bill-process.vat-challan-list') }}" class="btn btn-info" style="margin-right: 20px">Cancel</a>
        <a class="btn btn-primary submit-btn text-white ms-2">Submit</a>
    </div>

    </form>

    @else
        <div class="error-text-custom">Sorry, No data found for generate VAT challan no.</div>
    @endif

    <style>
        .x_content{
            /* font-family: arial !important; */
            color:#000 !important;
            font-size:13px;
        }
        .invoice-table, .invoice-table th, .invoice-table td{
            border-collapse: collapse !important;
            font-size:12.5px !important;
        }
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
            border: 1px solid #000 !important;
            border-bottom: 1px solid #000 !important;
            padding:1px !important;
        }
        .invoice-table td {
            border: 1px solid #000 !important;
            border-top: 1px solid #000 !important;
            padding:2px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black{
            color: #000 !important;
            font-size: 13px !important;
        }
        p{
            margin-bottom: 1px
        }
    </style>
    <style>
        .checkInvoice, .checkInvoiceAll{
            height: 15px;
            width: 15px;
        }
        .form-data label{
            color: #000;
        }
        .form-control-plaintext{
            padding: initial;
        }
        .error-text-custom{
            text-align: center;
            color:red;
            font-weight: bold;
            font-size: 20px
        }
    </style>

    <script>

        $(document).ready(function() {

            $('.custom-datepicker').datepicker({
                format: 'dd/mm/yyyy',
                startDate: '{{$lastChallanDate}}',
                endDate: new Date(), // disables dates after today
                autoclose: true,
                todayHighlight: true
            });

            $(".bottom-bar").removeClass('d-none');

            $('#checkInvoiceAll').on('change', function() {
                $('.checkInvoice').prop('checked', this.checked);
                serialGeneration();
            });

            $('.checkInvoice').on('change', function () {
                serialGeneration();
            });

            $('#challanDate').on('change', function () {
                // $('#checkInvoiceAll').prop('checked', false);
                // $('.checkInvoice').prop('checked', false);
                // $('.challanSerial').text('');
                serialGeneration();
            });

        });


        $(".submit-btn").click(function(e) {
            if ($("#challanDate").val() == "") {
                show_toastr('error', 'Please select VAT challan date.');
                return false;
            }

            if ($('.checkInvoice:checked').length === 0) {
                show_toastr('error', 'No invoice is checked.');
                return false;
            }else{

                // confirm check
                const swalWithBootstrapButtons = Swal.mixin({
                        customClass: {
                            confirmButton: "btn btn-success",
                            cancelButton: "btn btn-danger",
                        },
                        buttonsStyling: false,
                    });
                    swalWithBootstrapButtons
                        .fire({
                            title: "Are you sure to submit?",
                            text: "",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonText: "Yes, Process it!",
                            cancelButtonText: "No, cancel!",
                            reverseButtons: true,
                        })
                        .then((result) => {
                            if (result.isConfirmed) {
                                $('.submit-btn').html(
                                    '<span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span> Processing...'
                                );
                                $('.ajaxLoaderFormLoad').show();
                                $(".bottom-bar").addClass('d-none');
                                $(".table-form").css("pointer-events", "none");

                                $("#vatChallanForm").attr('action', '{{ route('bill-process.vat-challan-store') }}');
                                $("#vatChallanForm").attr('method', 'POST');
                                $("#vatChallanForm").submit();

                            } else if (result.dismiss === Swal.DismissReason.cancel) {
                            }
                        });
            }

        });

        function serialGeneration() {
            var challanDate = $("#challanDate").val();

            if (challanDate === '') {
                show_toastr('error', 'Please select VAT challan date.');
                $('.checkInvoice, #checkInvoiceAll').prop('checked', false);
                $('.challanSerial').html('');
                return false;
            }

            let [day, month, year] = challanDate.split('/');
            let challanMonth = parseInt(month, 10);
            let challanYear = parseInt(year, 10);
            let yearSuffix = year.slice(-2);
            let monthSuffix = month.padStart(2, '0');

            let serialPrefix = "VS-";
            let startSerial = 1;

            var lastVatChallanNo = $("#lastVatChallanNo").val(); // e.g., VS-000062505

            if (lastVatChallanNo !== '') {
                let lastSerial = parseInt(lastVatChallanNo.substring(3, 8), 10); // '00006' → 6
                let lastYear = parseInt(lastVatChallanNo.substring(8, 10), 10);  // '25'
                let lastMonth = parseInt(lastVatChallanNo.substring(10, 12), 10); // '05'

                // Convert year to 4-digit
                let fullLastYear = lastYear >= 70 ? 1900 + lastYear : 2000 + lastYear;

                // Determine financial year start for challan and last serial
                let challanFYStart = (challanMonth >= 7) ? challanYear : challanYear - 1;
                let lastFYStart = (lastMonth >= 7) ? fullLastYear : fullLastYear - 1;

                if (challanFYStart === lastFYStart) {
                    startSerial = lastSerial + 1;
                } else {
                    startSerial = 1;
                }
            }

            let counter = startSerial;

            $('tr').each(function () {
                let checkbox = $(this).find('.checkInvoice');
                let challanCell = $(this).find('.challanSerial');

                if (checkbox.prop('checked')) {
                    let serial = serialPrefix + counter.toString().padStart(5, '0') + yearSuffix + monthSuffix;
                    counter++;

                    if (challanCell.find('input').length === 0) {
                        challanCell.html('<input type="text" name="challan_no[]" readonly class="form-control-plaintext" />');
                    }
                    challanCell.find('input').val(serial);
                } else {
                    challanCell.html('');
                }
            });
        }


    </script>


@endsection
