
@extends('layouts.app')

@section('title')
    VAT Challan Details
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-4">
            <div class=" mb-0 text-primary" style="font-size:24px;">VAT Challan Details</div>
        </div>
        <div class="col-md-4 text-center">
            <a href="{{ route('bill-process.vat-challan-view-pdf', $challanInfo->challan_ref_no) }}" class="btn btn-warning text-dark">
                <i class="fa fa-print" aria-hidden="true"></i> Print
            </a>
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('bill-process.vat-challan-list') }}" class="btn btn-primary">Back</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-10 rounded">
                <div class="x_content" style="padding:0" id="printableArea2">
                    <div style="color: #000;text-align: right;position: absolute;
                        width: 100%;font-size: 17px !important;padding-right:10px;z-index:999">
                        {{-- Challan Ref No : {{$challanInfo->challan_ref_no}} --}}
                    </div>
                    <div class="row">
                        <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                            <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                            <p style="font-size: 17px !important;">ACCOUNTS DEPARTMENT</p>
                            <p style="font-size: 17px !important;">MUSHAK 11 STATEMENT</p>
                            {{-- <p style="font-size: 16px !important;text-transform: uppercase">Challan Date: {{$challanInfo->challan_date}}</p> --}}
                            <p style="font-size: 15px !important;text-transform: uppercase">VAT CHALLAN REF. NO: {{$challanInfo->challan_ref_no}}</p>
                        </div>
                        <div style="color: #000;width: 100%;padding-left:10px">Printing Date: {{date('d/m/Y')}}</div>

                    </div>

                    <div class="row mt-2">
                        <div class="col-md-12">
                            {{-- <p><strong class="">Subject: </strong>
                                {{ $firstBillSubject ? $firstBillSubject->bill_subject : '-' }}</p> --}}

                            <table class="table table-bordered mt-1 invoice-table">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Customer Name</th>
                                        <th>Address</th>
                                        <th>VAT<br>Reg. No.</th>
                                        <th>Invoice<br>No.</th>
                                        <th>Particulars</th>
                                        <th>Net<br>Amount</th>
                                        <th>VAT<br>Amount</th>
                                        <th>Total<br>Amount</th>
                                        <th>Challan No.</th>
                                        <th>Challan Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $grand_total_amount = 0;
                                        $grand_vat_amount = 0;
                                        $grand_total_amount_vat = 0;
                                        $k = 1;
                                    @endphp
                                    @foreach ($result as $customerId => $data)
                                        {{-- <tr>
                                            <td colspan="8" style="text-align: center; font-weight: bold;">
                                                Customer ID: {{ $customerId }}
                                                Customer Name: {{ $data['customer_name'] }}
                                            </td>
                                        </tr> --}}
                                        @foreach ($data['rows'] as $row)
                                            <tr>
                                                <td class="text-center">{{ $k }}</td>
                                                <td>{{ $data['customer_name'] }}</td>
                                                <td>{{ $data['address'] }}</td>
                                                <td>{{ $data['bin_no'] }}</td>
                                                <td>{{ $row->invoice_no }}</td>
                                                <td>{{ $row->bill_subject_desc }}</td>
                                                <td class="text-right">{{ priceFormat($row->total_amount) }}</td>
                                                <td class="text-right">{{ priceFormat($row->vat_amount) }}</td>
                                                <td class="text-right">{{ priceFormat($row->total_amount_vat) }}</td>
                                                <td class="text-center"><nobr>{{ $row->challan_no }}</nobr></td>
                                                <td class="text-center"><nobr>{{ $row->challan_date }}</nobr></td>
                                            </tr>
                                            @php
                                                $k++
                                            @endphp
                                        @endforeach
                                        {{-- <tr>
                                            <td colspan="5" style="text-align: right; font-weight: bold;">
                                                {{ $data['customer_name'] }} Total:</td>
                                            <td class="text-right" style="font-weight: bold;">{{ number_format($data['total']['total_amount'], 2) }}</td>
                                            <td class="text-right" style="font-weight: bold;">{{ number_format($data['total']['vat_amount'], 2) }}</td>
                                            <td class="text-right" style="font-weight: bold;">{{ number_format($data['total']['total_amount_vat'], 2) }}</td>
                                        </tr> --}}
                                        @php
                                            $grand_total_amount = $grand_total_amount + $data['total']['total_amount'];
                                            $grand_vat_amount = $grand_vat_amount + $data['total']['vat_amount'];
                                            $grand_total_amount_vat = $grand_total_amount_vat + $data['total']['total_amount_vat'];
                                        @endphp
                                    @endforeach
                                    <tr>
                                        <td colspan="6" style="text-align: right; font-weight: bold;">Grand Total:</td>
                                        <td class="text-right" style="font-weight: bold; background-color: #f0f0f0;">{{ number_format($grand_total_amount, 2) }}</td>
                                        <td class="text-right" style="font-weight: bold; background-color: #f0f0f0;">{{ number_format($grand_vat_amount, 2) }}</td>
                                        <td class="text-right" style="font-weight: bold; background-color: #f0f0f0;">{{ number_format($grand_total_amount_vat, 2) }}</td>
                                        <td colspan="2"></td>
                                    </tr>
                                </tbody>
                            </table>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .x_content{
            /* font-family: arial !important; */
            color:#000 !important;
            font-size:13px;
        }
        .invoice-table, .invoice-table th, .invoice-table td{
            border-collapse: collapse !important;
            font-size:12.5px !important;
        }
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
            border: 1px solid #000 !important;
            border-bottom: 1px solid #000 !important;
            padding:2px !important;
        }
        .invoice-table td {
            border: 1px solid #000 !important;
            border-top: 1px solid #000 !important;
            padding:2px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black{
            color: #000 !important;
            font-size: 13px !important;
        }
        p{
            margin-bottom: 1px
        }
    </style>
    <style>
        .text-center{
            text-align: center;
        }
    </style>

@endsection
