@extends('layouts.app')

@section('title')
    Active Inactive Bills
@endsection

@section('content')

<link href="{{ asset('plugins/nicelabel/css/jquery-nicelabel.css') }}" rel="stylesheet" />
<script src="{{ asset('plugins/nicelabel/js/jquery.nicelabel.js') }}"></script>



    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Active Inactive Bills</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <div class="col-md-5 mb-2">
                        <div class="d-flex">

                            <select name="customer_id" id="customer_id" class="form-control select2">
                                <option value="">Select Customer</option>
                                @foreach ($customers as $customer)
                                    <option value="{{ $customer->id }}"
                                        {{ $id == $customer->id ? 'selected' : '' }}>
                                        {{ $customer->customer_name }}</option>
                                @endforeach
                            </select>

                                &nbsp;&nbsp;
                            <a class="btn btn-primary ms-2 text-white btn-search">Search</a>
                            <a href="{{ route('active.inactive.bills') }}" class="btn btn-danger ms-2">Clear</a>
                        </div>
                    </div>

                    @if($customerInfo)
                    <div class="row">
                        <div class="col-md-12">
                            <h6><span class="text-dark">Address:</span> {{ $customerInfo->address }}</h6>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        @if(count($bills)>0)
        <table class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Bill No</th>
                    <th>Particulars</th>
                    <th>VAT<br>(%)</th>
                    {{-- <th>VAT<br>Status</th> --}}
                    <th>Qty</th>
                    <th>Unit<br>Price</th>
                    <th>Net<br>Amount</th>
                    <th>VAT<br>Amount</th>
                    <th>Total<br>Amount</th>
                    <th>Bill<br>Type</th>
                    <th>Active Status</th>
                    <th></th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $row->particulars }}</td>
                        <td class="text-right">{{ $row->vat_percent }}</td>
                        {{-- <td class="text-center">{{ ($row->vat_status=='1')? 'Y':'N' }}</td> --}}
                        <td class="text-right">{{ $row->qty }}</td>
                        <td class="text-right">{{ priceFormat($row->unit_price_vat) }}</td>
                        <td class="text-right">{{ priceFormat($row->total_amount) }}</td>
                        <td class="text-right">{{ priceFormat($row->vat_amount) }}</td>
                        <td class="text-right">{{ priceFormat($row->total_amount_vat) }}</td>
                        <td>{{ $row->bill_type }}</td>
                        <td>
                            <input type="checkbox" class="circle-nicelabel btn-status" id="{{$row->id}}"
                                value="{{$row->id}}" {{($row->status=='Active')? 'checked':''}}/>
                        </td>
                        <td>
                            <a data-size="xl" class="btn btn-success btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View"><i class="fa fa-eye"></i></a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <div style="width:100%;text-align:center">No data found.</div>
        @endif
    </div>

    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1;
            overflow-y: auto;
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px);
            overflow-y: auto;
        }
    </style>

    <script>
        $('.btn-search').click(function(){
            var customer_id = $('#customer_id').val();
            customer_id = customer_id.trim();
            if(customer_id==''){
                show_toastr('error', 'Please select customer.');
                return false;
            }else{
                $('.ajaxLoaderFormLoad').show();
                let url = "{{ url('/active-inactive-bills') }}/" + customer_id;
                window.location.href = url;
            }
        });
    </script>

    <script>
        $('input').nicelabel();

        $('.btn-status').click(function(){
            var M = $(this);
            var Mid = M.context.id;
            if ($(this).is(':checked')) {
                var statusType = 'Active';
            }else{
                var statusType = 'Inactive';
            }

            $.ajax({
                type: 'GET',
                url: '{{url("active-inactive-status")}}/' + Mid + '/' + statusType,
                success: function(data) {
                    if(data=='Active'){
                        M.prop('checked', true);
                    }else if(data=='Inactive'){
                        M.prop('checked', false);
                    }else{
                        show_toastr('error', 'Status not changed, refresh page.');
                        return false;
                    }
                }
            });
        });
    </script>

@endsection
