@extends('layouts.app')

@section('title')
    Bill View
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Bill (No- {{ str_pad($bill->id, 5, '0', STR_PAD_LEFT) }})</h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('bills.awaiting') }}" class="btn btn-primary">Awaiting Bills</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">

                    <div style="pointer-events: none">
                        <div class="row">
                            <div class="col-md-4">
                                <label for="customer_id">Customer* :</label>
                                <select id="customer_id" name="customer_id" class="form-control">
                                    <option value=""></option>
                                    @foreach ($customers as $row)
                                    <option value="{{$row->autoAcNo}}" {{ $autoAcNo == $row->autoAcNo ? 'selected' : '' }}
                                        data-extra="{{$row->bin_no}}">{{$row->customer_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="bin_number">Bin Number :</label>
                                <input type="number" id="bin_number" class="form-control" name="bin_number" value="{{$bill->bin_number}}"/>
                            </div>
                            <div class="col-md-4">
                                <label for="department_id">Department* :</label>
                                <select id="department_id" name="department_id" class="form-control">
                                    <option value=""></option>
                                    @foreach ($departments as $row)
                                        @if($row['divCode']!='000')
                                        <option value="{{$row['divCode']}}" {{ $bill->department_id == $row['divCode'] ? 'selected' : '' }}>{{$row['divName']}}</option>
                                        @endif
                                    @endforeach
                                </select>
                                <input type="hidden" id="billDivName" name="billDivName" value="{{ $bill->billDivName }}">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="particular">Particulars :</label>
                                <input type="text" id="particulars" class="form-control" name="particulars" value="{{ $bill->particulars }}" />
                            </div>
                            <div id="currency-container" class="col-md-4">
                                <label for="currency">Currency* :</label>
                                <input type="text" id="currency_rate" class="form-control" name="particulars" value="{{ $bill->currency }}" />
                            </div>

                            <div class="col-md-4">
                                <label for="currency_rate">Currency Rate* :</label>
                                <input type="text" id="currency_rate" class="form-control" name="particulars" value="{{ $bill->currency_rate }}" />
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-4">
                                <label for="qty">Bill Qty* :</label>
                                <input type="number" id="qty" min="1" class="form-control" name="qty" value="{{ $bill->qty }}" required />
                            </div>
                            <div class="col-md-4">
                                <label for="unit_price_vat">Unit Price* :</label>
                                <input type="number" id="unit_price_vat" min="1" step="0.01" class="form-control" name="unit_price_vat" value="{{ $bill->unit_price_vat }}" required />
                            </div>
                            <div class="col-md-4">
                                <label for="total_amount">Total Amount :</label>
                                <input type="number" id="total_amount" class="form-control" name="total_amount" value="{{ $bill->total_amount }}" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="vat_status">VAT Status :</label>
                                <select id="vat_status" name="vat_status" class="form-control select2">
                                    <option value="1" {{ $bill->vat_status == '1' ? 'selected' : '' }}>Yes</option>
                                    <option value="0" {{ $bill->vat_status == '0' ? 'selected' : '' }}>No</option>
                                </select>
                            </div>
                           <div class="col-md-4">
                                <label for="vat_percent">VAT (%)* :</label>
                                <select id="vat_percent" name="vat_percent" class="form-control select2">
                                    <option value=""></option>
                                    @foreach ($vatsetup as $vatsetups)
                                        <option value="{{ $vatsetups->vat }}" {{ $bill->vat_percent == $vatsetups->vat ? 'selected' : '' }}>
                                            {{ $vatsetups->vat }}
                                        </option>
                                    @endforeach
                                </select>
                                <input type="hidden" id="vat_percent_hidden" name="vat_percent_hidden" value="">
                            </div>
                            <div class="col-md-4">
                                <label for="total_amount_vat">Total Amount with VAT :</label>
                                <input type="number" id="total_amount_vat" value="{{ number_format($bill->total_amount_vat, 2, '.', '') }}" class="form-control"
                                    name="total_amount_vat" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="ref_no">Bill Ref. No :</label>
                                <input type="text" id="ref_no" class="form-control" name="ref_no" value="{{ $bill->ref_no }}" />
                            </div>
                            <div class="col-md-4">
                                <label for="ref_date">Bill Ref. Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="ref_date" id="ref_date" value="{{ $bill->ref_date }}" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="installation_date">Date of Installation :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="installation_date" id="installation_date" value="{{ $bill->installation_date }}" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="start_date">Bill Start Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="start_date" id="start_date" value="{{ $bill->start_date }}" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="end_date">Bill End Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="end_date" id="end_date" value="{{ $bill->end_date }}" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="activation_date">Activation Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="activation_date" id="activation_date" value="{{ $bill->activation_date }}" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="bill_subject_id">Bill Subject* :</label>
                                <select id="bill_subject_id" name="bill_subject_id" class="form-control select2" required>
                                    <option value=""></option>
                                    @foreach ($billSubjects as $billSubject)
                                        <option value="{{ $billSubject->id }}"
                                            {{ $bill->bill_subject_id == $billSubject->id ? 'selected' : '' }}>
                                                {{ $billSubject->bill_subject }} ({{ $billSubject->divName }})</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="bill_group">Bill Group* :</label>
                                <input type="text" id="bill_group" class="form-control" required name="bill_group" value="{{ $bill->bill_group }}" />
                            </div>
                            <div class="col-md-4">
                                <label for="order_sl_no">Bill Order Sl. No :</label>
                                <input type="number" id="order_sl_no" class="form-control" required name="order_sl_no" value="{{ $bill->order_sl_no }}" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="increase_start_date">Increase Start Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="increase_start_date" id="increase_start_date" value="{{ $bill->increase_start_date }}" placeholder="dd/mm/yyyy" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="yearly_increase_percent">Yearly Increase (%) :</label>
                                <input type="number" id="yearly_increase_percent" class="form-control" name="yearly_increase_percent" value="{{ $bill->yearly_increase_percent }}" />
                            </div>
                            <div class="col-md-4">
                                <label for="increase_period">Increase Period :</label>
                                <select id="increase_period" class="form-control select2" name="increase_period">
                                    <option value=""></option>
                                    <option value="3" {{ $bill->increase_period == '3' ? 'selected' : '' }}>3 months</option>
                                    <option value="6" {{ $bill->increase_period == '6' ? 'selected' : '' }}>0.5 years</option>
                                    <option value="12" {{ $bill->increase_period == '12' ? 'selected' : '' }}>1 year</option>
                                    <option value="24" {{ $bill->increase_period == '24' ? 'selected' : '' }}>2 years</option>
                                    <option value="36" {{ $bill->increase_period == '36' ? 'selected' : '' }}>3 years</option>
                                    <option value="48" {{ $bill->increase_period == '48' ? 'selected' : '' }}>4 years</option>
                                    <option value="60" {{ $bill->increase_period == '60' ? 'selected' : '' }}>5 years</option>
                                    <option value="120" {{ $bill->increase_period == '120' ? 'selected' : '' }}>10 years</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="bill_type">Bill Type* :</label>
                                <select id="bill_type" name="bill_type" class="form-control select2" required>
                                    <option value=""></option>
                                    <option value="One Time" {{ $bill->bill_type == 'One Time' ? 'selected' : '' }}> One Time</option>
                                    <option value="Monthly" {{ $bill->bill_type == 'Monthly' ? 'selected' : '' }}>Monthly</option>
                                    <option value="Quarterly" {{ $bill->bill_type == 'Quarterly' ? 'selected' : '' }}>Quarterly</option>
                                    <option value="Half Yearly" {{ $bill->bill_type == 'Half Yearly' ? 'selected' : '' }}>Half Yearly</option>
                                    <option value="Yearly" {{ $bill->bill_type == 'Yearly' ? 'selected' : '' }}>Yearly</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="vat_refund">VAT Refund* :</label>
                                <select id="vat_refund" name="vat_refund" class="form-control select2">
                                    <option value="1" {{ $bill->vat_refund == '1' ? 'selected' : '' }}>Yes</option>
                                    <option value="0" {{ $bill->vat_refund == '0' ? 'selected' : '' }}>No</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="status">Status* :</label>
                                <select id="status" name="status" class="form-control select2">
                                    <option value="Active" {{ $bill->status == 'Active' ? 'selected' : '' }}>Active</option>
                                    <option value="Inactive" {{ $bill->status == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                        </div>

                    </div>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="work_order">Work order / PO* :</label>
                                @if($bill->workorder_file)
                                    <div class="existing-file">
                                        <a href="{{ asset('storage/workorders/' . $bill->workorder_file) }}" target="_blank" title="view file">
                                            <u>{{ $bill->workorder_file }}</u>
                                        </a></div>
                                @endif
                            </div>

                            <div class="form-group col-md-4">
                                <label for="installation_uat">Installation / UAT* :</label>
                                @if($bill->instalation_file)
                                    <div class="existing-file">
                                        <a href="{{ asset('storage/installation/' . $bill->instalation_file) }}" target="_blank" title="view file">
                                            <u>{{ $bill->instalation_file }}</u>
                                        </a>
                                    </div>
                                @endif
                            </div>

                            <div class="form-group col-md-4">
                                <label for="delivery_challan">Delivery challan :</label>
                                @if($bill->deliverychallan_file)
                                    <div class="existing-file">
                                        <a href="{{ asset('storage/deliverychallan/' . $bill->deliverychallan_file) }}" target="_blank" title="view file">
                                            <u>{{ $bill->deliverychallan_file }}</u>
                                        </a>
                                    </div>
                                @endif
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <input type="hidden" name="approve" id="billApprove">
                                <a href="{{ url()->previous() }}" class="btn btn-info">Cancel</a>
                                <a href="{{ route('bills.awaiting.statusChange', [$bill->id,200]) }}" class="btn btn-primary">Approve</a>
                                <a data="{{ route('bills.awaiting.statusChange', [$bill->id,3]) }}"
                                    class="btn btn-danger delete-btn text-white cursor-pointer">Reject</a>

                            </div>
                        </div>

                </div>
            </div>
        </div>
    </div>

    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>
@endsection

@section('script')

<script>

    $(document).on("click", ".delete-btn", function () {
        var hrefValue = $(this).attr('data');
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: "btn btn-success",
                cancelButton: "btn btn-danger",
            },
            buttonsStyling: false,
        });
        swalWithBootstrapButtons
            .fire({
                title: "Are you sure to reject it?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, Reject it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: true,
            })
            .then((result) => {
                if (result.isConfirmed) {
                    window.location.replace(hrefValue);
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                }
            });
    });


</script>


<style>
    /* for awaiting approval */
    form label{
        font-weight: bold;
    }
    .select2-container--default .select2-selection--single, .form-control{
        border:1px solid #F7F7F7 !important;
        background-color: #F7F7F7;
    }
</style>

@endsection

