@extends('layouts.app')

@section('title')
    Bills
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Manage Bills</h4>
        </div>
        <div class="col-md-6 text-right">
            @can('Create Bill')
                <a href="{{ route('bills.create') }}" class="btn btn-primary">Add New</a>
            @endcan
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <form action="{{ route('bills.index') }}" method="GET" autocomplete="off">
                        <div class="row d-flex align-items-end">
                            <div class="col-md-3">
                                <div class="form-group">
                                    {{-- <label for="customer" class="form-label">Customer</label> --}}
                                    <select name="customer" id="customer" class="form-control select2">
                                        <option value="">Select customer</option>
                                        @foreach ($customers as $customer)
                                            <option value="{{ $customer->id }}"
                                                {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->customer_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    {{-- <label for="bill_no" class="form-label">Bill No</label> --}}
                                    <input type="text" name="bill_no" id="bill_no" class="form-control"
                                        value="{{request('bill_no')}}" placeholder="Bill No">
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <button class="btn btn-primary btn-block" type="submit">Filter</button>
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <a href="{{ route('bills.index') }}" class="btn btn-danger btn-block">Clear</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


            <form action="{{ route('bills.index') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $bills->total() }}" {{ $perPage == $bills->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
            </form>

    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Bill No</th>
                    <th>Customer</th>
                    <th>Particulars</th>
                    <th>Subject</th>
                    <th>Bill Group</th>
                    <th>Qty</th>
                    <th>Net Amount</th>
                    <th>VAT Amount</th>
                    <th>Total Amount</th>
                    <th>Bill Type</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td>{{ $loop->iteration + ($bills->currentPage() - 1) * $bills->perPage() }}</td>
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td>{{ $row->particulars }}</td>
                        {{-- <td>{{ $row->billSubject->bill_subject ?? '' }}</td> --}}

                        <td style="width:120px;">
                            @php
                                $string = $row->billSubject->bill_subject ?? '';
                                $formattedString = preg_replace('/([\/_])/', '$1 ', $string);
                            @endphp
                            {{ $formattedString }}
                        </td>
                        <td class="text-center">{{ $row->bill_group ? $row->bill_group : '-' }}</td>
                        <td class="text-right">{{ $row->qty }}</td>
                        <td class="text-right">{{ priceFormat($row->total_amount) }}</td>
                        <td class="text-right">{{ priceFormat($row->vat_amount) }}</td>
                        <td class="text-right">{{ priceFormat($row->total_amount_vat) }}</td>
                        <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                        <td>
                            @if($row->status=='Active')
                                Active
                            @else
                                <span style="color:red"><b>Inactive</b></span>
                            @endif
                        </td>
                        <td>
                            <a data-size="xl" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a>

                            @if(trim($row->bill_note)!='')
                                <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                    data-url="{{ route('bills.show.note', $row->id) }}" data-ajax-popup="true"
                                    style="background-color: #89949a; border-color:#89949a;"
                                    data-title="View Bill Note" data-bs-toggle="tooltip" title="View Bill Note"
                                    data-original-title="Bill Note"><i class="fa fa-info-circle"></i></a>
                            @endif

                            @php
                                // $pInfo = \App\Models\Bill::paid_status($row->id)
                                // $processedBill=\App\Models\BillProcess::where('bill_id', $row->id)->first();
                            @endphp

                            @if($row->approval!=1)
                                @can('Edit Bill')
                                    <a href="{{ route('bills.edit', $row->id) }}" class="btn btn-success btn-sm">Edit</a>
                                @endcan
                                @can('Delete Bill')
                                    <form id="delete-form-{{ $row->id }}" class="d-inline"
                                        action="{{ route('bills.destroy', $row->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <a class="btn btn-danger btn-sm alert-btn text-white cursor-pointer">Delete</a>
                                    </form>
                                @endcan
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="row">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $bills->firstItem() }} to {{ $bills->lastItem() }} of {{ $bills->total() }} entries
            </div>
            <div>
                {{ $bills->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>

    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1;
            overflow-y: auto;
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px);
            overflow-y: auto;
        }
    </style>

@endsection
