@extends('layouts.app')

@section('title')
    Proposal Info
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Proposal Info</h4>
        </div>
    </div>

            <form action="{{ route('bills.proposal-info') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $bills->total() }}" {{ $perPage == $bills->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
            </form>

    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Bill No</th>
                    <th>Customer</th>
                    <th>Bill Group</th>
                    <th>Qty</th>
                    <th>Net Amount</th>
                    <th>VAT Amount</th>
                    <th>Total Amount</th>
                    <th>Bill Type</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td>{{ $loop->iteration + ($bills->currentPage() - 1) * $bills->perPage() }}</td>
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td class="text-center">{{ $row->bill_group ? $row->bill_group : '-' }}</td>
                        <td class="text-right">{{ $row->qty }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->vat_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount_vat) }}</td>
                        <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                        <td>
                            {{ ($row->approval==2 && $row->bill_editor_id=='')? 'Pending':'' }}
                            {{ ($row->approval==1)? 'Approved':'' }}
                            {{ ($row->approval=='')? 'Approved':'' }}
                            {{ ($row->approval==3)? 'Rejected':'' }}
                            {{ ($row->approval==2 && $row->bill_editor_id!='')? 'Rejected':'' }}
                        </td>
                        <td>

                            <a data-size="xl" class="btn btn-success btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.proposal-info-show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a>


                            {{-- Proposal edit button --}}
                            @php $showEditBtn = false; @endphp
                            @if($row->approval==2 && $row->bill_editor_id=='')
                                @php $showEditBtn = true; @endphp
                            @endif
                            @if($row->approval==3)
                                @php $showEditBtn = true; @endphp
                            @endif
                            @if($row->approval==2 && $row->bill_editor_id!='')
                                @php $showEditBtn = true; @endphp
                            @endif

                            @if($showEditBtn)
                                <a href="{{ route('bills.proposal-info-edit', $row->id) }}" class="btn btn-info btn-sm">Edit</a>
                                <form id="delete-form-{{ $row->id }}" class="d-inline"
                                    action="{{ route('bills.proposal-info-delete') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="deletedID" value="{{ $row->id }}">
                                    <a data="delete-form-{{ $row->id }}" class="btn btn-danger btn-sm delete-btn text-white cursor-pointer">Delete</a>
                                </form>
                            @endif

                            @php
                                $notes = \App\Models\BillNote::where('bill_id',$row->id)->first();
                            @endphp

                            @if($notes)
                            <a data-size="lg" class="btn btn-warning btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.reject.note', $row->id) }}" data-ajax-popup="true"
                                data-title="View Reject Note" data-bs-toggle="tooltip" title="View Reject Note"
                                data-bs-custom-class="custom-tooltip">
                                <i class="fa fa-info-circle"></i>
                            </a>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <script>
        $(document).on("click", ".delete-btn", function () {
            var hrefValue = $(this).attr('data');
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: "btn btn-success",
                    cancelButton: "btn btn-danger",
                },
                buttonsStyling: false,
            });
            swalWithBootstrapButtons
                .fire({
                    title: "Are you sure?",
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, Delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true,
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        $("#"+hrefValue).submit();
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                    }
                });
        });
    </script>

    <div class="row">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $bills->firstItem() }} to {{ $bills->lastItem() }} of {{ $bills->total() }} entries
            </div>
            <div>
                {{ $bills->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>

    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1;
            overflow-y: auto;
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px);
            overflow-y: auto;
        }
    </style>

@endsection
