@extends('layouts.app')

@section('title')
    Rejected Bills
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Rejected Bills</h4>
        </div>
        <div class="col-md-6 text-right">
            @can('Create Bill')
                <a href="{{ route('bills.create') }}" class="btn btn-primary">Add New Bill</a>
            @endcan
        </div>
    </div>


            <form action="{{ route('bills.rejected') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $bills->total() }}" {{ $perPage == $bills->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
            </form>


<form id="billListForm">
    @csrf
    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center"><input type="checkbox" class="custom-checkbox" id="select-all" /><label
                            for="select-all">
                        </label>
                    </th>
                    <th>Sl</th>
                    <th>Bill No</th>
                    <th>Customer</th>
                    <th>Qty</th>
                    <th>Currency</th>
                    <th>Unit Price</th>
                    <th>Total Amount</th>
                    <th>VAT Amount</th>
                    <th >Bill Type</th>
                    <th style="width: 100px">Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td class="text-center">
                            <input type="checkbox" class="custom-checkbox" id="selected_bills_{{ $row->id }}"
                                name="selected_bills[]" value="{{ $row->id }}" /><label
                                for="selected_bills_{{ $row->id }}"></label>
                        </td>
                        <td>{{ $loop->iteration }}</td>
                        <!-- <td>{{ $loop->iteration + ($bills->currentPage() - 1) * $bills->perPage() }}</td> -->
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td class="text-right">{{ $row->qty }}</td>
                        <td>{{ $row->currency }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->unit_price_vat) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->vat_amount) }}</td>
                        <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                        <td>
                            {{-- <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true" data-title="View Bill"
                                data-bs-toggle="tooltip" title="View" data-original-title="View">View</a> --}}

                            @can('Edit Bill')
                                <a href="{{ route('bills.edit', $row->id) }}" class="btn btn-success btn-sm">Edit</a>
                            @endcan

                            {{-- @can('Delete Bill')
                                <a data="{{ route('bills.single.delete', [$row->id,'rejected']) }}"
                                    class="btn btn-danger btn-sm delete-btn text-white cursor-pointer">Delete</a>
                            @endcan --}}

                            @can('Edit Bill')
                                {{-- <a href="{{ route('bills.request', $row->id) }}" class="btn btn-warning btn-sm text-dark">Request Approval</a> --}}
                            @endcan


                            @php
                                $notes = \App\Models\BillNote::where('bill_id',$row->id)->first();
                            @endphp

                            @if($notes)
                            <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.reject.note', $row->id) }}" data-ajax-popup="true"
                                data-title="View Reject Note" data-bs-toggle="tooltip" title="View Reject Note"
                                data-bs-custom-class="custom-tooltip">
                                <i class="fa fa-info-circle"></i>
                            </a>
                            @endif


                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <input type="hidden" id="status" name="status">
</form>


    <div class="row">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $bills->firstItem() }} to {{ $bills->lastItem() }} of {{ $bills->total() }} entries
            </div>
            <div>
                {{ $bills->appends(['per_page' => $perPage])->links('vendor.pagination.customrejectbill-pagination') }}
            </div>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-md-12 text-center">
            @if (count($bills) > 0)
                @can('Edit Bill')
                    {{-- <a onclick="statusChangeBatch(1)" class="btn btn-warning text-dark">Request Approval</a> --}}
                @endcan
                @can('Delete Bill')
                <a onclick="statusChangeBatch(0)" class="btn btn-danger text-white">Delete</a>
                @endcan
            @endif
        </div>
    </div>

<script>
    $('#select-all').click(function() {
        $('input[name="selected_bills[]"]').prop('checked', this.checked);
    });

    function statusChangeBatch(status){
        var checkedCount = $('input[name="selected_bills[]"]:checked').length;
        if(checkedCount>0){
            $('#status').val(status);
            $('#billListForm').attr("method","post");
            $('#billListForm').attr("action","{{ route('bills.rejectedBatch') }}");
            $('#billListForm').submit();
        }else{
            show_toastr('error', 'Please, check bill from bill list');
        }
    }

    $(document).on("click", ".delete-btn", function () {
        var hrefValue = $(this).attr('data');
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: "btn btn-success",
                cancelButton: "btn btn-danger",
            },
            buttonsStyling: false,
        });
        swalWithBootstrapButtons
            .fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: true,
            })
            .then((result) => {
                if (result.isConfirmed) {
                    window.location.replace(hrefValue);
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                }
            });
    });
</script>

<style>
    {
        display: inline-block;
        position: absolute;
        z-index: 2;
    }
</style>

<script>
    $(document).on('click', '[data-ajax-popup="true"]', function (e) {
    e.preventDefault();
    var url = $(this).data('url');
    var title = $(this).data('title');

    $.ajax({
        url: url,
        success: function (response) {
            // Assuming you have a modal with the ID 'commonModal'
            $('#commonModal .modal-title').html(title);
            $('#commonModal .modal-body').html(response);
            $('#commonModal').modal('show');
        },
        error: function (response) {
            // Handle error
            alert('Something went wrong!');
        }
    });
});

</script>

<style>
        .custom-tooltip .tooltip-inner {
        text-align: center;
    }

</style>

<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .container {
        flex: 1;
        overflow-y: auto;
    }

    .row {
        flex-grow: 1;
    }

    .table-responsive {
        max-height: calc(100vh - 250px);
        overflow-y: auto;
    }
</style>


@endsection
