
<form id="billEditForm" name="billEditForm" action="{{ route('bill.details.update') }}" method="POST" autocomplete="off">
    @csrf
<div class="modal-body">
    {{$bill->id}}
    {{$bill->customer_id}}
    <div class="row">
        <div class="col-md-6">
            <label for="bill_no">Bill No* :</label>
            <input type="text" id="bill_no" class="form-control" name="bill_no" value="{{ $bill->bill_no }}" />
        </div>
        <div class="col-md-6">
            <label for="customer_id">Customer* :</label>
            <select id="customer_id" name="customer_id" class="form-control" required>
                <option value="">--Select Customer--</option>
                @foreach ($customers as $customer)
                    <option value="{{$customer->id}}"  {{ $bill->customer_id == $customer->id ? 'selected' : '' }}>{{$customer->customer_name}}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="particular">Particulars :</label>
            <input type="text" id="particulars" class="form-control" name="particulars" value="{{ $bill->particulars }}" />
        </div>
        <div class="col-md-6">
            <label for="qty">Bill Qty* :</label>
            <input type="number" id="qty" class="form-control" name="qty" value="{{ $bill->qty }}" required />
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="unit_price_vat">Unit Price + VAT* :</label>
            <input type="text" id="unit_price_vat" class="form-control" name="unit_price_vat" value="{{ $bill->unit_price_vat }}" required />
        </div>
        <div class="col-md-6">
            <label for="total_amount">Total Amount* :</label>
            <input type="number" id="total_amount" class="form-control" name="total_amount" value="{{ $bill->total_amount }}" required />
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="bill_subject_id">Bill Subject :</label>
            <select id="bill_subject_id" name="bill_subject_id" class="form-control">
                <option value="">--Select Bill Subject--</option>
                @foreach ($billSubjects as $billSubject)
                    <option value="{{ $billSubject->id }}" {{ $bill->bill_subject_id == $billSubject->id ? 'selected' : '' }}>{{ $billSubject->bill_subject }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-6">
            <label for="ref_no">Bill Ref. No :</label>
            <input type="text" id="ref_no" class="form-control" name="ref_no" value="{{ $bill->ref_no }}" />
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="ref_date">Bill Ref. Date :</label>
            <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                <input type="text" class="form-control has-feedback-left custom-datepicker" name="ref_date" id="ref_date" value="{{ $bill->ref_date }}" placeholder="Enter Ref Date" autocomplete="off">
                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                <span id="inputSuccess2Status" class="sr-only">(success)</span>
            </div>
        </div>
        <div class="col-md-6">
            <label for="installation_date">Date of Installation :</label>
            <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                <input type="text" class="form-control has-feedback-left custom-datepicker" name="installation_date" id="installation_date" value="{{ $bill->installation_date }}" placeholder="Enter Installation Date" autocomplete="off">
                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                <span id="inputSuccess2Status" class="sr-only">(success)</span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="activation_date">Activation Date :</label>
            <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                <input type="text" class="form-control has-feedback-left custom-datepicker" name="activation_date" id="activation_date" value="{{ $bill->activation_date }}" placeholder="Enter Activation Date" autocomplete="off">
                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                <span id="inputSuccess2Status" class="sr-only">(success)</span>
            </div>
        </div>
        <div class="col-md-6">
            <label for="start_date">Bill Start Date :</label>
            <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                <input type="text" class="form-control has-feedback-left custom-datepicker" name="start_date" id="start_date" value="{{ $bill->start_date }}" placeholder="Enter Start Date" autocomplete="off">
                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                <span id="inputSuccess2Status" class="sr-only">(success)</span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="end_date">Bill End Date :</label>
            <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                <input type="text" class="form-control has-feedback-left custom-datepicker" name="end_date" id="end_date" value="{{ $bill->end_date }}" placeholder="Enter End Date" autocomplete="off">
                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                <span id="inputSuccess2Status" class="sr-only">(success)</span>
            </div>
        </div>
        <div class="col-md-6">
            <label for="department_id">Department :</label>
            <select id="department_id" name="department_id" class="form-control">
                <option value="">--Select Department--</option>
                @foreach ($departments as $department)
                    <option value="{{ $department->id }}" {{ $bill->department_id == $department->id ? 'selected' : '' }}>{{ $department->department_name }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="bill_group">Bill Group :</label>
            <input type="text" id="bill_group" class="form-control" name="bill_group" value="{{ $bill->bill_group }}" />
        </div>
        <div class="col-md-6">
            <label for="bill_type">Bill Type :</label>
            <select id="bill_type" name="bill_type" class="form-control">
                <option value="">--Select Bill Type--</option>
                <option value="Monthly" {{ $bill->bill_type == 'Monthly' ? 'selected' : '' }}>Monthly</option>
                <option value="Quarterly" {{ $bill->bill_type == 'Quarterly' ? 'selected' : '' }}>Quarterly</option>
                <option value="Half Yearly" {{ $bill->bill_type == 'Half Yearly' ? 'selected' : '' }}>Half Yearly</option>
                <option value="Yearly" {{ $bill->bill_type == 'Yearly' ? 'selected' : '' }}>Yearly</option>
            </select>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="payment_type">Payment Type :</label>
            <select id="payment_type" name="payment_type" class="form-control">
                <option value="">--Select Payment Type--</option>
                <option value="Prepaid" {{ $bill->payment_type == 'Prepaid' ? 'selected' : '' }}>Prepaid</option>
                <option value="Postpaid" {{ $bill->payment_type == 'Postpaid' ? 'selected' : '' }}>Postpaid</option>
            </select>
        </div>
        <div class="col-md-6">
            <label for="vat_percent">VAT (%) :</label>
            <input type="text" id="vat_percent" class="form-control" name="vat_percent" value="{{ $bill->vat_percent }}" />
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="vat_status">VAT Status :</label>
            <input type="text" id="vat_status" class="form-control" name="vat_status" value="{{ $bill->vat_status }}" />
        </div>
        <div class="col-md-6">
            <label for="yearly_increase_percent">Yearly Increase (%) :</label>
            <input type="text" id="yearly_increase_percent" class="form-control" name="yearly_increase_percent" value="{{ $bill->yearly_increase_percent }}" />
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <label for="increase_start_date">Increase Start Date :</label>
            <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                <input type="text" class="form-control has-feedback-left custom-datepicker" name="increase_start_date" id="increase_start_date" value="{{ $bill->increase_start_date }}" placeholder="Enter Increase Date" autocomplete="off">
                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                <span id="inputSuccess2Status" class="sr-only">(success)</span>
            </div>
        </div>
        <div class="col-md-6">
            <label for="order_sl_no">Bill Order Sl. No :</label>
            <input type="text" id="order_sl_no" class="form-control" name="order_sl_no" value="{{ $bill->order_sl_no }}" />
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <label for="status">Status :</label>
            <select id="status" name="status" class="form-control">
                <option value="Active" {{ $bill->status == 'Active' ? 'selected' : '' }}>Active</option>
                <option value="Inactive" {{ $bill->status == 'Inactive' ? 'selected' : '' }}>Inactive</option>
            </select>
        </div>
    </div>
</div>

<div class="modal-footer">
    <input type="button" value="Close" class="btn btn-danger" data-dismiss="modal">
    {{-- <button type="submit" class="btn btn-primary">Submit</button> --}}
</div>
</form>

<style>
    form label {
        margin-bottom: 2px;
        margin-top: 8px;
    }
</style>

{{-- <form action="{{ route('bill.details.update', $bill->id) }}" method="POST">
    <label for="name">Name:</label><br>
    <input type="text" id="name" name="name" required><br><br>


    <input type="submit" value="Submit">
</form> --}}

<script>
    $('#billEditForm').on('submit', function(event) {
                //event.preventDefault(); // Prevent the default form submission

                $.ajax({
                    url: $(this).attr('action'),
                    type: $(this).attr('method'),
                    data: $(this).serialize(),
                    success: function(response) {
                        console.log(response);
                        return false;
                        //$('#response').html(response);
                    },
                    error: function(xhr, status, error) {
                        console.log(error);
                        //$('#response').html('An error occurred: ' + error);
                    }
                });
            });
</script>
