@extends('layouts.app')

@section('style')
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
@endsection

@section('title')
    Bill Details
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Customer Bill Details</h4>
        </div>
    </div>

    <form name="billForm" id="billForm" class="form-horizontal form-label-left" autocomplete="off">
        @csrf
    <div class="row rounded" id="searchBox" style="background-color: #e6e6f0;padding-top: 8px;margin-bottom:10px;">
        <div class="col-md-6" >
            <div class="form-group row " style="display:none;">
                <label class="control-label col-md-4 col-sm-4 ">Customer Id</label>
                <div class="col-md-8 col-sm-8 ">
                    <input type="text" class="form-control" style="background-color: #ffffee; pointer-events:none;"
                        id="customer_show_id" name="customer_show_id" value="{{($id)? $id:''}}">
                </div>
            </div>
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Customer Name</label>
                <div class="col-md-8 col-sm-8">
                    <select id="customer_id" name="customer_id" class="form-control select2">
                        <option value="">--Select--</option>
                        @if($customers)
                            @foreach ($customers as $row)
                                <option value="{{$row->id}}" {{($id==$row->id)? 'selected':''}}>{{$row->customer_name}}</option>
                            @endforeach
                        @endif
                    </select>
                </div>
            </div>
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Address</label>
                <div class="col-md-8 col-sm-8 ">
                    <input type="text" id="address" name="address" class="form-control" style="background-color: #ffffee; pointer-events:none;" value="{{($address)? $address:''}}">
                </div>
            </div>
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Ref Date From</label>
                <div class="col-md-8 col-sm-8 ">
                    <input type="text" id="from_date" name="from_date" placeholder="dd/mm/yyyy" class="form-control custom-datepicker" value="{{isset($from_date)? $from_date:''}}" style="width:100% !important;">
                </div>
            </div>
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Ref Date To</label>
                <div class="col-md-8 col-sm-8 ">
                    <input type="text" id="to_date" name="to_date" placeholder="dd/mm/yyyy" class="form-control custom-datepicker" value="{{isset($to_date)? $to_date:''}}" style="width:100% !important;">
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Bill Status</label>
                <div class="col-md-8 col-sm-8 ">
                    <select id="bill_status" name="bill_status" class="form-control">
                        <option value="11" {{(isset($bill_status) && $bill_status==11)? 'selected':''}}>All Type</option>
                        <option value="" {{(isset($bill_status) && $bill_status=='')? 'selected':''}}>Pending</option>
                        <option value="0" {{(isset($bill_status) && $bill_status==0)? 'selected':''}}>Rejected</option>
                        <option value="1" {{(isset($bill_status) && $bill_status==1)? 'selected':''}}>Approved</option>
                    </select>
                </div>
            </div>
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Bill Type</label>
                <div class="col-md-8 col-sm-8 ">
                    <select id="bill_type" name="bill_type" class="form-control">
                        <option value="" {{(isset($bill_type) && $bill_type=='')? 'selected':''}}>All Type</option>
                        <option value="Monthly" {{(isset($bill_type) && $bill_type=='Monthly')? 'selected':''}}>Monthly</option>
                        <option value="Quarterly" {{(isset($bill_type) && $bill_type=='Quarterly')? 'selected':''}}>Quarterly</option>
                        <option value="Half Yearly" {{(isset($bill_type) && $bill_type=='Half Yearly')? 'selected':''}}>Half Yearly</option>
                        <option value="Yearly" {{(isset($bill_type) && $bill_type=='Yearly')? 'selected':''}}>Yearly</option>
                        <option value="One Time" {{(isset($bill_type) && $bill_type=='One Time')? 'selected':''}}>One Time</option>
                    </select>
                </div>
            </div>
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Filter Type</label>
                <div class="col-md-8 col-sm-8 ">
                    <select id="filter_type" name="filter_type" class="form-control">
                        <option value="id" {{(isset($filter_type) && $filter_type=='id')? 'selected':''}}>Bill No</option>
                        <option value="ref_no" {{(isset($filter_type) && $filter_type=='ref_no')? 'selected':''}}>Bill Ref No</option>
                        <option value="particulars" {{(isset($filter_type) && $filter_type=='particulars')? 'selected':''}}>Particulars</option>
                    </select>
                </div>
            </div>
            <div class="form-group row ">
                <label class="control-label col-md-4 col-sm-4 ">Order By</label>
                <div class="col-md-8 col-sm-8 ">
                    <select id="order_by" name="order_by" class="form-control">
                        <option value="asc" {{(isset($order_by) && $order_by=='asc')? 'selected':''}}>Ascending</option>
                        <option value="desc" {{(isset($order_by) && $order_by=='desc')? 'selected':''}}>Descending</option>
                    </select>
                </div>
            </div>
            <div class="form-group row ">
                <div class="col-md-12 col-sm-12" style="text-align:right;">
                    <a href="{{ route('bill.dashboard') }}" class="btn btn-success">Reset</a>
                    <button type="submit" class="btn btn-primary" id="btnFilter">Apply Filters</button>
                </div>
            </div>

        </div>
    </div>

    </form>

    <div style="clear:both"></div>

    <div class="row" id="resultBox">
        <table id="datatable" class="table table-striped table-bordered gridTable" style="width:100%">
            <thead>
                <tr>
                    <th>Bill No</th>
                    <th>Particulars</th>
                    <th>Ref No</th>
                    <th>Ref Date</th>
                    <th>Qty</th>
                    <th>Total<br>Amount</th>
                    <th>Bill Type</th>
                    <th>Order<br>Sl No</th>
                    <th>Approval</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @if($bills)
                    @foreach ($bills as $row)
                        <tr>
                            <td><b>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</b></td>
                            <td style="width:250px !important;">{{ $row->particulars }}</td>
                            <td><nobr>{{ $row->ref_no }}</nobr></td>
                            <td><nobr>{{ $row->ref_date }}</nobr></td>
                            <td style="text-align:center;">{{ $row->qty }}</td>
                            <td>{{ \App\Models\Settings::priceFormat($row->total_amount) }}</td>
                            <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                            <td>{{ $row->order_sl_no }}</td>
                            <td>
                                <?php
                                if($row->approval=='1'){
                                    echo 'Approved';
                                }else if($row->approval=='0'){
                                    echo 'Rejected';
                                }else{
                                    echo 'Pending';
                                }
                                ?>
                            </td>
                            <td>{{ $row->status }}</td>
                            <td>
                                <a data-size="xl" class="btn btn-info btn-sm text-white cursor-pointer"
                                    data-url="{{ route('bill.details.show', $row->id) }}" data-ajax-popup="true"
                                    data-title="View Bill Details" data-bs-toggle="tooltip" title="View"
                                    data-original-title="View">View</a>

                                {{-- <a data-size="lg" class="btn btn-success btn-sm text-white cursor-pointer"
                                    data-url="{{ route('bill.details.edit', $row->id) }}" data-ajax-popup="true"
                                    data-title="Bill Update" data-bs-toggle="tooltip" title="Edit"
                                    data-original-title="Edit">Edit</a> --}}


                                {{-- <form id="delete-form-{{ $row->id }}" class="d-inline"
                                    action="{{ route('bills.destroy', $row->id) }}" method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <a class="btn btn-danger btn-sm alert-btn text-white cursor-pointer">Delete</a>
                                </form> --}}
                            </td>
                        </tr>
                    @endforeach
                @endif
            </tbody>
        </table>
        {{-- @if(sizeof($bills)>0)
        <div style="text-align:center;width: 100%;">
            <br>
            <a href="{{ route('bill.dashboard') }}" class="btn btn-info">Cancel</a>
            <button class="btn btn-primary" id="btnSubmit">Update Bill</button>
        </div>
        @endif --}}

    </div>

    <style>
        #searchBox .form-group{
            margin-bottom:0px;
        }
        #searchBox .form-control{
            padding: 3px 5px;
            height: 30px;
        }
        .select2-container--default .select2-selection--single .select2-selection__rendered{
            line-height: 18px;
            height: 30px;
        }
        .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--multiple{
            min-height: 31px;
        }
        /* .select2-container{
            width: 313px !important;
        } */

        .gridTable thead th{
            padding: 5px 5px 5px 5px;
        }
        .gridTable tbody td{
            padding: 0px !important;
            vertical-align: middle !important;
        }
        .gridTable tbody td .form-control{
            padding: 3px;
            vertical-align: middle;
        }
        .datepick{
            width:115px !important;
        }
        .rightText{
            text-align: right;
        }
    </style>
@endsection

@section('script')
    <script>

        // Customer changing function
        $('#customer_id').change(function(){
            var customerID = $('#customer_id').val();
            $('#customer_show_id').val(customerID);
            $('#address').val('');
            if(parseInt(customerID)!=0){
                $.ajax({
                    type: 'GET',
                    url: '{{url("bill-dashboard-address")}}/'+customerID,
                    success: function(data) {
                        $('#address').val(data);
                    }
                });
            }

        });

        $(document).ready(function() {
            $('#datatable').DataTable().destroy();
            // $('#datatable-buttons').empty();
            // var table = $('#datatable').DataTable({});
            // table.destroy();

            $('#datatable').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'pdf', 'print'
                ],
                ordering: false
            });
        });

        $('#btnFilter').click(function(){

            var customer_id = $('#customer_id').val();
            if(customer_id==''){
                show_toastr('error', 'Please Select Customer', 'success');
                return false;
            }else{
                // proceed to submit
                $('#billForm').attr('method', 'post');
                $('#billForm').attr('action', '{{ route('bill.dashboard.search') }}');
                $("#billForm").submit();
            }
        });

        // $(document).on('click', '.btnDelete', function() {
        //     if (confirm('are you want to delete this!')) {
        //         $(this).closest('tr').remove();
        //     }
        // });

    </script>
@endsection


