<form action="{{ route('bill-subject.update', $billSubject->id) }}" method="POST">
    @csrf
    @method('PATCH')

    <div class="modal-body">
        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <label for="bill_subject">Bill Subject*</label>
                    <input type="text" class="form-control" id="bill_subject" name="bill_subject" placeholder="Enter Bill Subject" value="{{ $billSubject->bill_subject }}" required>
                </div>

                <div class="form-group">
                    <label for="hs_code">HS Code</label>
                    <input type="text" class="form-control" id="hs_code" name="hs_code"
                        placeholder="Enter HS Code" value="{{ $billSubject->hs_code }}">
                </div>

                <div class="form-group">
                    <label for="divCode">Department* :</label>
                    <select id="divCode" name="divCode" class="form-control select2" required>
                        <option value="">--Select Department--</option>
                        @foreach ($departments as $row)
                        @if($row['divCode']!='000')
                        <option value="{{$row['divCode']}}"
                            {{($row['divCode']==$billSubject->divCode)? 'selected':''}}>{{$row['divName']}}</option>
                        @endif
                        @endforeach
                    </select>
                    <input type="hidden" id="divName" name="divName" value="{{$billSubject->divName}}">
                </div>

                <div class="form-group">
                    <label for="gl_code">GL Subject*</label>
                    <select id="gl_code" name="gl_code" class="form-control select2" required>
                        <option value="">--Select GL Subject--</option>
                    </select>
                    <input type="hidden" id="gl_subject" name="gl_subject" value="{{$billSubject->gl_subject}}">
                    <input type="hidden" id="autoAcNo" name="autoAcNo" value="{{$billSubject->autoAcNo}}">
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <input type="button" value="{{ __('Cancel') }}" class="btn btn-danger" data-dismiss="modal">
        <input type="submit" value="{{ __('Update') }}" class="btn btn-primary">
    </div>
</form>
<script>
    $('#gl_code').change(function(){
        var selOption = $(this).children('option:selected');
        var selText = selOption.text();
        $('#gl_subject').val(selText);
        $('#autoAcNo').val($('#gl_code').val());
    });
    $('#divCode').change(function(){
        var selOption = $(this).children('option:selected');
        var selText = selOption.text();
        $('#divName').val(selText);
    });
    $('#divCode').change(function(){
        var chartDepId = $(this).val();
        $.ajax({
            type: 'GET',
            url: '{{url("income-list-by-divcode")}}/'+chartDepId,
            success: function(data) {
                $('#gl_code').html(data);
            }
        });
    });

    var chartDepId = $('#divCode').val();
    $.ajax({
        type: 'GET',
        url: '{{url("income-list-by-divcode")}}/'+chartDepId,
        success: function(data) {
            $('#gl_code').html(data);
            $('#gl_code').val({{$billSubject->autoAcNo}}).trigger('change');
        }
    });

    $('.select2').select2({
        dropdownParent: $('#commonModal')
    });
</script>

