@extends('layouts.app')

@php
    use Illuminate\Support\Facades\DB;
@endphp

@section('title')
    Collection Create
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Manage Collection & Receive</h4>
        </div>
    </div>

    <form name="collectionForm" id="collectionForm" autocomplete="off">
        @csrf
        <div class="row">
            <div class="col-md-12">
                <div class="x_panel p-20">
                    <div class="x_title">
                        <h5>Collection Entry Form</h5>
                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content collectionBox" style="padding:0">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="customer_id">Customer* :</label>
                                <select id="customer_id" name="customer_id" class="form-control select2" required>
                                    <option value="">--Select Customer--</option>
                                    @if ($customers)
                                        @foreach ($customers as $row)
                                            <option value="{{$row['autoAcNo']}}" {{($row['autoAcNo']==$customerId)? 'selected':''}}>{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="ref_no">Collection Ref. No* :</label>
                                <input type="text" id="ref_no" class="form-control" name="ref_no" required />
                            </div>
                            <div class="col-md-6">
                                <label for="coll_date">Collection Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="coll_date" id="coll_date" placeholder="dd/mm/yyyy"
                                        value="{{date('d/m/Y')}}" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="instrument_mode">Instrument Mode :</label>
                                <select id="instrument_mode" name="instrument_mode" class="form-control">
                                    <option value="Cheque">Cheque</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="instrument_no">Instrument No :</label>
                                <input type="text" id="instrument_no" class="form-control" name="instrument_no" />
                            </div>
                            <div class="col-md-4">
                                <label for="instrument_date">Instrument Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="instrument_date" id="instrument_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label for="bank_id">Bank Name* :</label>
                                <select id="bank_id" name="bank_id" class="form-control select2" required>
                                    <option value="">--Select Bank--</option>
                                    @if ($banks)
                                        @foreach ($banks as $row)
                                            <option value="{{ $row->id }}">{{ $row->bank_name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <label for="received_amount">Received Amount :</label>
                                <input type="number" id="received_amount" class="form-control" name="received_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                            <div class="col-md-3">
                                <label for="tds_amount">TDS Amount :</label>
                                <input type="number" id="tds_amount" class="form-control" name="tds_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                            <div class="col-md-3">
                                <label for="vat_amount">VAT Amount :</label>
                                <input type="number" id="vat_amount" class="form-control" name="vat_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                            <div class="col-md-3">
                                <label for="adjust_amount">Adjust Amount :</label>
                                <input type="number" id="adjust_amount" class="form-control" name="adjust_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <label for="total_coll_amount">Total Collection Amount :</label>
                                <input type="number" id="total_coll_amount" class="form-control readmode"
                                    name="total_coll_amount" />
                                <input type="hidden" id="total_remaining" class="form-control readmode"
                                    name="total_remaining" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <label for="money_receipt_no">Money Receipt No :</label>
                                <input type="text" id="money_receipt_no" class="form-control"
                                    name="money_receipt_no" />
                            </div>
                            <div class="col-md-3">
                                <label for="money_receipt_date">Money Receipt Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="money_receipt_date" id="money_receipt_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="bank_slip_no">Bank Slip No :</label>
                                <input type="text" id="bank_slip_no" class="form-control" name="bank_slip_no" />
                            </div>
                            <div class="col-md-3">
                                <label for="bank_deposit_date">Bank Deposit Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="bank_deposit_date" id="bank_deposit_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label for="dep_bank_id">Depository Bank Name* :</label>
                                <select id="dep_bank_id" name="dep_bank_id" class="form-control select2" required>
                                    <option value="">--Select Depository Bank--</option>
                                    @if ($depBanks)
                                        @foreach ($depBanks as $row)
                                            <option value="{{$row['autoAcNo']}}">{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label for="adj_remarks">Adjustment Remarks :</label>
                                <textarea id="adj_remarks" class="form-control" name="adj_remarks"></textarea>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        {{-- grid table  --}}
        <div class="col-md-12">
            <div class="row" id="resultBox" style="width:100%">
                <table id="datatable-buttonsqq" class="table table-striped table-bordered gridTable" style="width:100%">
                    <thead>
                        <tr>
                            <th>Invoice<br>No</th>
                            <th class="text-right">Invoice<br>Value</th>
                            <th class="text-right">Collected<br>Amount</th>
                            <th class="text-right">Remaining<br>Amount</th>
                            <th class="text-right">Collection<br>Amount</th>
                            <th class="text-right">Collection<br>Date</th>
                            <th class="text-right">Collection<br>No</th>
                            <th></th>
                        </tr>
                    </thead>

                    <tbody>
                        @if ($bills)
                            @foreach ($bills as $row)
                                @php
                                    $billId = $row->id;
                                    $totalPaid = 0;
                                    $paidInfo = DB::selectOne("SELECT IFNULL(SUM(CAST(collection_amount AS DOUBLE)),0) AS total_paid
                                    FROM collection_chds
                                    WHERE bill_process_id=$billId");
                                    if ($paidInfo) {
                                        $totalPaid = $paidInfo->total_paid;
                                    }
                                @endphp
                                <tr>
                                    <td>
                                        <input type="hidden" class="form-control billId" name="billId[]"
                                            value="{{ $row->id }}">
                                        <nobr>{{ $row->invoice_no }}</nobr>
                                    </td>
                                    <td><input type="text" class="form-control totalAmt readmode" name="totalAmt[]"
                                            value="{{ $row->total_amount_vat }}"></td>
                                    <td><input type="text" class="form-control collectedAmt readmode"
                                            name="collectedAmt[]" value="{{ $totalPaid }}"></td>
                                    <td><input type="text" class="form-control remainingAmt readmode"
                                            name="remainingAmt[]" value="{{ $row->total_amount_vat - $totalPaid }}"></td>
                                    <td><input type="text" class="form-control collectionAmt readmode"
                                            name="collectionAmt[]"></td>
                                    <td><input type="text" class="form-control collectionDate custom-datepicker"
                                            name="collectionDate[]"></td>
                                    <td><input type="text" class="form-control collectionNo" name="collectionNo[]">
                                    </td>

                                    <td style="width:38px;text-align:center;font-size:20px;">
                                        <span class="flagPaid" style="display:none;"><i class="fa fa-check"
                                                style="color:#0bbd0b;"></i></span>
                                        @if ($row->payment_status != 'Paid' || ($row->payment_status = '' || $row->payment_status == null))
                                            <span class="flagUnpaid"><i class="fa fa-close"
                                                    style="color:#FF0000;"></i></span>
                                        @endif
                                        <input type="hidden" class="form-control flagStatus" name="flagStatus[]"
                                            value="{{ $row->payment_status }}">
                                    </td>

                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>

                @if (sizeof($bills) > 0)
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <br />
                            <a href="{{ route('collection.index') }}" class="btn btn-info">Cancel</a>
                            <button class="btn btn-primary" id="btnSubmit">Collection Submit</button>
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </form>

    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }

        .collectionBox label {
            color: #2c2b2b;
        }

        .collectionBox input,
        .collectionBox select {
            padding: 3px 7px;
            height: 38px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            height: 38px;
        }

        .select2-container--default .select2-selection--single,
        .select2-container--default .select2-selection--multiple {
            min-height: 38px;
        }

        .gridTable thead th {
            padding: 5px;
        }

        .gridTable tbody td {
            padding: 0px !important;
            vertical-align: middle !important;
        }

        .gridTable tbody td input {
            height: 38px;
            text-align: right;
        }
    </style>

@endsection

@section('script')
    <script>
        // Customer changing function
        $('#customer_id').change(function() {
            var customerID = $(this).val();
            if (parseInt(customerID) != 0) {
                window.location.replace("{{ url('collection/create') }}/" + customerID);
            }
        });
    </script>

    <script>
        // By Salaquzzaman @ 24-05-2024
        function calcAmount() {

            // main form total calculation
            var rcvAmt = parseFloat($('#received_amount').val());
            var tdsAmt = parseFloat($('#tds_amount').val());
            var vatAmt = parseFloat($('#vat_amount').val());
            var adjAmt = parseFloat($('#adjust_amount').val());
            if (isNaN(rcvAmt) || rcvAmt == "") {
                rcvAmt = 0;
            }
            if (isNaN(tdsAmt) || tdsAmt == "") {
                tdsAmt = 0;
            }
            if (isNaN(vatAmt) || vatAmt == "") {
                vatAmt = 0;
            }
            if (isNaN(adjAmt) || adjAmt == "") {
                adjAmt = 0;
            }
            var totalColAmt = (rcvAmt + tdsAmt + vatAmt + adjAmt);
            $('#total_coll_amount').val(totalColAmt.toFixed(2));
            $('#total_remaining').val(0);
            $('#total_remaining').val(totalColAmt);

            // grid value changes
            var remainingAmt = 0;
            var total_remaining = 0;

            $(".totalAmt").each(function() {

                var thisRow = $(this).closest('tr');

                var collectedAmt = parseFloat(thisRow.find('.collectedAmt').val());
                var totalAmt = parseFloat(this.value) - collectedAmt;
                if (isNaN(this.value) || this.value == "") {
                    totalAmt = 0;
                }

                thisRow.find('.collectionAmt').val(0);
                thisRow.find('.remainingAmt').val(0);
                total_remaining = parseFloat($('#total_remaining').val());

                if (total_remaining > totalAmt) {
                    total_remaining = total_remaining - totalAmt;
                    $('#total_remaining').val(total_remaining);
                    thisRow.find('.collectionAmt').val(totalAmt.toFixed(2));
                    thisRow.find('.remainingAmt').val(0);
                } else {
                    // total_remaining = $('#total_remaining').val();
                    $('#total_remaining').val(0);
                    thisRow.find('.collectionAmt').val(total_remaining.toFixed(2));
                    remainingAmt = totalAmt - total_remaining;
                    thisRow.find('.remainingAmt').val(remainingAmt.toFixed(2));
                }

            });

            // Payment Status Update
            $(".totalAmt").each(function() {
                var thisRow = $(this).closest('tr');
                var collectedAmt = parseFloat(thisRow.find('.collectedAmt').val());
                var totalAmt = parseFloat(this.value)
                if (isNaN(this.value) || this.value == "") {
                    totalAmt = 0;
                }
                var fTotal = totalAmt - collectedAmt;
                var remainingAmt = parseFloat(thisRow.find('.remainingAmt').val());

                if (remainingAmt <= 0) {
                    thisRow.find('.flagStatus').val('Paid');
                    paidTick(1, thisRow);
                } else {
                    thisRow.find('.flagStatus').val('Partial Paid');
                    paidTick(0, thisRow);
                }
                var collectionAmt = parseFloat(thisRow.find('.collectionAmt').val());
                if (isNaN(collectionAmt) || collectionAmt == "") {
                    thisRow.find('.flagStatus').val('Unpaid');
                    paidTick(0, thisRow);
                }

            });

        }

        function paidTick(x, ropo) {
            if (x == 1) {
                ropo.find('.flagPaid').show();
                ropo.find('.flagUnpaid').hide();
            } else {
                ropo.find('.flagPaid').hide();
                ropo.find('.flagUnpaid').show();
            }
        }

        $('#btnSubmit').click(function() {

            if ($('#customer_id').val() == '') {
                show_toastr('error', 'Missing Customer');
                return false;
            }

            if ($('#ref_no').val() == '') {
                show_toastr('error', 'Missing Refference No');
                return false;
            }

            if ($('#bank_id').val() == '') {
                show_toastr('error', 'Missing Customer Bank');
                return false;
            }

            if ($('#dep_bank_id').val() == '') {
                show_toastr('error', 'Missing Depository Bank');
                return false;
            }

            var totalColAmt = parseFloat($('#total_coll_amount').val());
            if (isNaN(totalColAmt) || totalColAmt == "" || totalColAmt == 0) {
                show_toastr('error', 'Missing Collection Amount');
                return false;
            } else {
                // proceed to submit
                $('#collectionForm').attr('method', 'post');
                $('#collectionForm').attr('action', '{{ route('collection.store') }}');
                $("#collectionForm").submit();
            }

        });
    </script>
@endsection
