@extends('layouts.app')
@section('title')
    Advanced Collection Create
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0"> Advanced Collection Create </h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('advanced.collection') }}" class="btn btn-primary">Advanced Collection</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                {{-- <div class="x_title">
                    <h5> Advanced Collection Entry </h5>
                    <div class="clearfix"></div>
                </div> --}}
                <div class="x_content" style="padding:0">

                    <form action="{{ route('advanced.collection.store') }}" method="POST" autocomplete="off" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <label for="customer_id">Customer* :</label>
                                <select id="customer_id" name="customer_id" class="form-control select2">
                                    <option value="">--Select Customer--</option>
                                    @foreach ($customers as $row)
                                    <option value="{{$row->autoAcNo}}">{{$row->customer_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="instrument_mode">Instrument Mode* :</label>
                                <select id="instrument_mode" name="instrument_mode" class="form-control select2">
                                    <option value="Bank">Bank</option>
                                    <option value="Cash">Cash</option>
                                </select>
                            </div>
                            <div class="col-md-6 dep_bank">
                                <label for="dep_bank_id">Bank* :</label>
                                <select id="dep_bank_id" name="dep_bank_id" class="form-control select2" required>
                                    <option value="">--Select Bank--</option>
                                    @if ($depBanks)
                                            @foreach ($depBanks as $row)
                                                <option value="{{ $row['autoAcNo'] }}"
                                                    data-extra="{{ $row['divCode'] }}">{{ $row['udAcName'] }}</option>
                                            @endforeach
                                    @endif
                                </select>
                                <input type="hidden" id="bankName" name="bankName">
                                <input type="hidden" id="bankDivCode" name="bankDivCode">
                            </div>
                            <div class="col-md-6 dep_cash" style="display:none">
                                <label for="dep_cash_id">Account* :</label>
                                <select id="dep_cash_id" name="dep_cash_id" class="form-control select2">
                                    <option value="">--Select Account--</option>
                                    @if ($depCash)
                                        @foreach ($depCash as $row)
                                            <option value="{{$row['autoAcNo']}}">{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="department_id">Department* :</label>
                                <select id="department_id" name="department_id" class="form-control select2" required>
                                    <option value="">--Select Department--</option>
                                    @foreach ($departments as $row)
                                    @if($row['divCode']!='000')
                                    <option value="{{$row['divCode']}}">{{$row['divName']}}</option>
                                    @endif
                                    @endforeach
                                </select>
                                <input type="hidden" id="depDivName" name="depDivName">
                            </div>
                            <div class="col-md-6">
                                <label for="instrument_no">Instrument No :</label>
                                <input type="text" id="instrument_no" class="form-control" name="instrument_no"/>
                            </div>
                            <div class="col-md-6">
                                <label for="instrument_date">Instrument Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text"
                                        class="form-control has-feedback-left custom-datepicker"
                                        name="instrument_date" id="instrument_date"
                                        placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left"
                                        aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label for="amount">Amount* :</label>
                                <input type="number" id="amount" min="1" class="form-control" name="amount" required />
                            </div>
                            <div class="col-md-6">
                                <label for="attachment">Attachment :</label>
                                <input type="file" name="attachment" class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('advanced.collection') }}" class="btn btn-info">Cancel</a>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>

    <script>
        // $('#divCode').change(function(){
        //     var selOption = $(this).children('option:selected');
        //     var selText = selOption.text();
        //     $('#divName').val(selText);
        // });
    </script>
@endsection


@section('script')
    <script>
        $('#department_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#depDivName').val(selText);
        });

        $('#dep_bank_id').change(function() {
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#bankName').val(selText);
            var divCode = selOption.data('extra');
            $('#bankDivCode').val(divCode);
        });

        $('#dep_bank_id').attr('required', 'required');
        $('#instrument_mode').change(function(){
            if($('#instrument_mode').val()=='Bank'){
                $('.dep_bank').show();
                $('#dep_bank_id').attr('required', 'required');
                $('#dep_cash_id').removeAttr('required');
                $('.dep_cash').hide();
            }else{ // cash
                $('.dep_cash').show();
                $('#dep_cash_id').attr('required', 'required');
                $('#dep_bank_id').removeAttr('required');
                $('.dep_bank').hide();
            }
        });






    </script>
@endsection
