@extends('layouts.app')

@section('title')
    Advanced Collection
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Manage  Advanced Collection</h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('advanced.collection.create') }}" class="btn btn-primary">Add New</a>
        </div>
    </div>



    <form action="{{ route('advanced.collection') }}" method="GET" class="num_filter px-4">
        <label for="per_page">Show</label>
        <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
            <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
            <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
            <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
            <option value="{{ $advancedcollections->total() }}" {{ $perPage == $advancedcollections->total() ? 'selected' : '' }}>All</option>
        </select>
        Entries
    </form>


    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>

                    <th>Sl</th>
                    <th>Collected Date</th>
                    <th>Customer</th>
                    <th>Type</th>
                    <th>Bank</th>
                    <th>Amount</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
               @foreach ($advancedcollections as $advancedcollection )
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ ($advancedcollection->created_at)? date('d/m/Y',strtotime($advancedcollection->created_at)):'' }}</td>
                        <td>{{ $customerNames[$advancedcollection->customer] ?? 'Unknown' }}</td>
                        <td>{{ $advancedcollection->instrument_mode }}</td>
                        <td>{{ $bankNames[$advancedcollection->bank] ?? '-' }}</td>
                        <td>{{ $advancedcollection->amount }}</td>
                        <td>
                            <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('advanced.collection.view', $advancedcollection->id) }}" data-ajax-popup="true"
                                data-title="View Advanced Collection" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View
                            </a>

                            {{-- <a href="{{ route('advanced.collection.edit', $advancedcollection->id) }}" class="btn btn-success btn-sm "
                                data-title="Edit Advanced Collection" title="Edit"
                                data-original-title="Edit">Edit
                            </a> --}}

                            {{-- <a href="{{ route('advanced.collection.delete', $advancedcollection->id) }}" class="btn btn-danger btn-sm "
                                data-title="Delete Advanced Collection" title="Delete"
                                data-original-title="Delete">Delete
                            </a> --}}
                        </td>

                    </tr>

                @endforeach
            </tbody>
        </table>
    </div>


    <div class="row">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $advancedcollections->firstItem() }} to {{ $advancedcollections->lastItem() }} of {{ $advancedcollections->total() }} entries
            </div>
            <div>
                {{ $advancedcollections->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>


    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>


    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1;
            overflow-y: auto;
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px);
            overflow-y: auto;
        }
    </style>


@endsection
