@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
Collection Cancellation
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Collection Cancellation</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('cancel.coll.preview') }}" method="get" autocomplete="off">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">Collection Ref No</label>
                                                <input type="text" id="ref_no" name="ref_no" class="form-control" value="{{request('ref_no')}}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('cancel.coll.preview') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>


    @if(request('ref_no')!='' && $pay)

    <div class="card-body">
    <div class="row">
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Collection Ref. No:</b></div>
            <p class="text-muted mb-3">{{ $pay->ref_no ? $pay->ref_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Customer:</b></div>
            <p class="text-muted mb-3">{{ $pay->customer_id && $pay->customer ? $pay->customer->customer_name : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Advanced Collection:</b></div>
            <p class="text-muted mb-3">{{ $pay->advance_amount ? \App\Models\Settings::priceFormat($pay->advance_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Total Paid Amount (inc. Adv):</b></div>
            <p class="text-muted mb-3">{{ $pay->total_coll_amount ? \App\Models\Settings::priceFormat($pay->total_coll_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Instrument Mode:</b></div>
            <p class="text-muted mb-3">{{ $pay->instrument_mode ? $pay->instrument_mode : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Instrument No:</b></div>
            <p class="text-muted mb-3">{{ $pay->instrument_no ? $pay->instrument_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Instrument Date:</b></div>
            <p class="text-muted mb-3">{{ $pay->instrument_date ? $pay->instrument_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bank Name:</b></div>
            <p class="text-muted mb-3">{{ $pay->customerBank ? $pay->customerBank->bank_name : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Received Amount:</b></div>
            <p class="text-muted mb-3">{{ $pay->received_amount ? \App\Models\Settings::priceFormat($pay->received_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>TDS Amount:</b></div>
            <p class="text-muted mb-3">{{ $pay->tds_amount ? \App\Models\Settings::priceFormat($pay->tds_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VDS Amount:</b></div>
            <p class="text-muted mb-3">{{ $pay->vat_amount ? \App\Models\Settings::priceFormat($pay->vat_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Adjust Amount:</b></div>
            <p class="text-muted mb-3">{{ $pay->adjust_amount ? \App\Models\Settings::priceFormat($pay->adjust_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Money Receipt No:</b></div>
            <p class="text-muted mb-3">{{ $pay->money_receipt_no ? $pay->money_receipt_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Money Receipt Date:</b></div>
            <p class="text-muted mb-3">{{ $pay->money_receipt_date ? $pay->money_receipt_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bank Slip No:</b></div>
            <p class="text-muted mb-3">{{ $pay->bank_slip_no ? $pay->bank_slip_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Posting Date:</b></div>
            <p class="text-muted mb-3">{{ $pay->bank_deposit_date ? $pay->bank_deposit_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Depository Account Name:</b></div>
            <p class="text-muted mb-3">{{ $udAcName ? $udAcName : '-' }}</p>
        </div>
        {{-- <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Created at:</b></div>
            <p class="text-muted mb-3">{{ $pay->created_at ? \Carbon\Carbon::parse($pay->created_at)->format('d F, Y') : '-' }}</p>
        </div> --}}
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Attachment File:</b></div>
            @if($pay->attachment)
                @php
                    $fileUrl = asset('storage/vds-certificate/' . $pay->attachment);
                @endphp
                <div style="display: flex; align-items: center; margin-bottom: 10px;">
                    <a href="{{ $fileUrl }}" target="_blank" title="view file">
                        <u>{{ $pay->attachment }}</u>
                    </a>
                </div>
            @else
                <p class="text-muted mb-3">-</p>
            @endif
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>TDS Certificate:</b></div>
            @if($pay->tds_certificate)
                @php
                    $fileUrl = asset('storage/vds-certificate/' . $pay->tds_certificate);
                @endphp
                <div style="display: flex; align-items: center; margin-bottom: 10px;">
                    <a href="{{ $fileUrl }}" target="_blank" title="view file">
                        <u>{{ $pay->tds_certificate }}</u>
                    </a>
                </div>
            @else
                <p class="text-muted mb-3">-</p>
            @endif
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VDS Certificate:</b></div>
            @if($pay->vds_certificate)
                @php
                    $fileUrl = asset('storage/vds-certificate/' . $pay->vds_certificate);
                @endphp
                <div style="display: flex; align-items: center; margin-bottom: 10px;">
                    <a href="{{ $fileUrl }}" target="_blank" title="view file">
                        <u>{{ $pay->vds_certificate }}</u>
                    </a>
                </div>
            @else
                <p class="text-muted mb-3">-</p>
            @endif
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Adjustment Remarks:</b></div>
            <p class="text-muted mb-3">{{ $pay->adj_remarks ? $pay->adj_remarks : '-' }}</p>
        </div>
    </div>

    <div class="row">
        @if($payChd)
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>SL</th>
                    <th>Invoice No</th>
                    <th>Bill No</th>
                    <th>Currency</th>
                    <th>Collection Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($payChd as $chd)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{$chd->invoice_no}}</td>
                    <td>
                        @php
                            $billInfo = \App\Models\BillProcess::find($chd->bill_process_id)
                        @endphp
                        {{ str_pad($billInfo->bill_id, 5, '0', STR_PAD_LEFT) }}
                    </td>
                    <td>
                        @php
                            $billInfo = \App\Models\BillProcess::find($chd->bill_process_id);
                        @endphp

                        {{$billInfo->currency}}
                    </td>
                    <td>{{ $chd->collection_amount ? \App\Models\Settings::priceFormat($chd->collection_amount) : '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endif
    </div>

    <div class="row">
        <div class="col-md-12 text-center">
            <a data="{{ route('cancel.coll.details', $pay->id) }}"
                class="btn btn-warning delete-btn text-dark cursor-pointer">Cancel Collection</a>
        </div>
    </div>

    </div>


    @else
        @if(request('ref_no')!='')
        <div style="text-align: center;">Sorry, Collection data not found.</div>
        @endif
    @endif

    <script>
        $(document).on("click", ".delete-btn", function () {
            var hrefValue = $(this).attr('data');
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: "btn btn-success",
                    cancelButton: "btn btn-danger",
                },
                buttonsStyling: false,
            });
            swalWithBootstrapButtons
                .fire({
                    title: "Are you sure to cancel this collection?",
                    text: "Collection data also delete from accounts!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, Cancel Collection",
                    cancelButtonText: "No, Do Not Cancel",
                    reverseButtons: true,
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        window.location.replace(hrefValue);
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                    }
                });
        });
    </script>
@endsection




