@extends('layouts.app')

@section('title')
Collection List
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Collection List</h4>
        </div>
        <div class="col-md-6 text-right">
            @can('Create Collection')
                <a href="{{ route('coll.entry') }}" class="btn btn-primary">New Collection</a>
            @endcan

        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" style="font-size: 17px;">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            {{ session('success') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <form action="{{ route('collection.index') }}" method="GET">
                        <div class="row d-flex align-items-end">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">Start Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="start_date" id="start_date" value="{{ request('start_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">End Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="end_date" id="end_date" value="{{ request('end_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="instrument_mode">Type :</label>
                                    <select id="instrument_mode" name="instrument_mode" class="form-control">
                                        <option value="All" {{ (request('instrument_mode')=='All')? 'selected':'' }}>All</option>
                                        <option value="Cheque" {{ (request('instrument_mode')=='Cheque')? 'selected':'' }}>Cheque</option>
                                        <option value="Cash" {{ (request('instrument_mode')=='Cash')? 'selected':'' }}>Cash</option>
                                        <option value="BEFTN" {{ (request('instrument_mode')=='BEFTN')? 'selected':'' }}>BEFTN/RTGS</option>
                                        <option value="Pay Order" {{ (request('instrument_mode')=='Pay Order')? 'selected':'' }}>Pay Order</option>
                                        <option value="DD" {{ (request('instrument_mode')=='DD')? 'selected':'' }}>DD</option>
                                        <option value="Advance" {{ (request('instrument_mode')=='Advance')? 'selected':'' }}>Advance</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="customer" class="form-label">Customer</label>
                                    <select name="customer" id="customer" class="form-control select2">
                                        <option value="">Select customer</option>
                                        @foreach ($customers as $customer)
                                            <option value="{{ $customer->id }}"
                                                {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->customer_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="ref_no" class="form-label">Ref No</label>
                                    <input type="text" name="ref_no" id="ref_no" class="form-control"
                                        value="{{request('ref_no')}}" placeholder="Ref No">
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <button class="btn btn-primary btn-block" type="submit">Filter</button>
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <a href="{{ route('collection.index') }}" class="btn btn-danger btn-block">Clear</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


            <form action="{{ route('collection.index') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $collections->total() }}" {{ $perPage == $collections->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
                @foreach (request()->except('per_page', 'page') as $key => $value)
                    <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endforeach
            </form>





    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl No</th>
                    <th>Ref No</th>
                    <th>Customer</th>
                    <th>Type</th>
                    <th>Total Amount</th>
                    <th>Posting Date</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($collections as $row)
                    <tr>
                        <!-- <td>{{ $loop->iteration }}</td> -->
                        <td>{{ $loop->iteration + ($collections->currentPage() - 1) * $collections->perPage() }}</td>
                        <td>{{ $row->ref_no ? $row->ref_no : '-' }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td>{{ ($row->instrument_mode=='')? 'Advance':$row->instrument_mode }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_coll_amount) }}</td>
                        <td>{{ $row->bank_deposit_date ? $row->bank_deposit_date : '-' }}</td>
                        <td>
                            <a data-size="xl" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('collection.show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Collection" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="row">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $collections->firstItem() }} to {{ $collections->lastItem() }} of {{ $collections->total() }} entries
            </div>
            <div>
                {{ $collections->appends(request()->except('page'))->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>


    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1;
            overflow-y: auto;
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px);
            overflow-y: auto;
        }
    </style>


@endsection
