@extends('layouts.app')

@section('title')
    Customer Edit
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Edit Customer</h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('customers.index') }}" class="btn btn-primary">Customers</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_title">
                    <h5>Edit Customer Details</h5>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content" style="padding:0">

                    <form id="customerForm" autocomplete="off">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-12">
                                <label for="customer_id">Customer ID* :</label>
                                <input type="number" id="customer_id" class="form-control" name="customer_id"
                                    value="{{ $customer->id }}" readonly />
                            </div>
                            <input type="hidden" name="autoAcNo" value="{{ $customer->autoAcNo }}">
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="customer_name">Customer Name* :</label>
                                <input type="text" id="customer_name" class="form-control" name="customer_name"
                                    value="{{ $customer->customer_name }}" required />
                            </div>
                            <div class="col-md-6">
                                <label for="divCode">Department* :</label>
                                <select id="divCode" name="divCode" class="form-control" required>
                                    <option value="000">Common</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="phone">Phone/Telephone* :</label>
                                <input type="text" id="phone" class="form-control" name="phone"
                                    value="{{ $customer->phone }}" required />
                            </div>
                            <div class="col-md-6">
                                <label for="autoAcNo">Account Customer* :</label>
                                <select id="autoAcNo" name="autoAcNo" class="form-control select2" required>
                                    <option value="">--Select Account Customer--</option>
                                    @if ($acCustomers)
                                        @foreach ($acCustomers as $row)
                                        <option value="{{$row['autoAcNo']}}"
                                            {{($row['autoAcNo']==$customer->autoAcNo)? 'selected':''}}>{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="bin_no">BIN No* :</label>
                                <input type="text" id="bin_no" class="form-control" name="bin_no" value="{{ $customer->bin_no }}" required />
                            </div>
                            <div class="col-md-6">
                                <label for="address">Address :</label>
                                <textarea id="address" class="form-control" rows="1" name="address">{{ $customer->address }}</textarea>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <label for="attention_person">Attention Person:</label>
                                <div class="d-flex">
                                    <select id="attention_person" name="attention_person" class="form-control">
                                        <option value="">--Select Attention Person--</option>
                                        @if ($attentions)
                                            @foreach ($attentions as $row)
                                                <option value="{{$row->id}}"
                                                    {{ ($row->id == $customer->attention_person) ? 'selected' : '' }}>
                                                    {{$row->attention_name}}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select> &nbsp;&nbsp;
                                    <button type="button" class="btn btn-success ms-2" id="btnAttention">
                                        <i class="fa fa-plus"></i>
                                    </button>
                                </div>
                            </div>

                            <div class="col-md-6" id="newAttentionBox" style="display:none">
                                <label for="newAttentionPerson">Type New Attention Person Name:</label>
                                <div class="d-flex">
                                    <input type="text" id="newAttentionPerson" name="newAttentionPerson" class="form-control">
                                     &nbsp;&nbsp;
                                    <button type="button" class="btn btn-success ms-2" id="btnAttentionSave">
                                        Save
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <h5 class="mb-0 text-primary">Billing Contact</h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="billing_name">Billing Name* :</label>
                                <input type="text" id="billing_name" class="form-control" name="billing_name"
                                    value="{{ $customer->billing_name }}" required />
                            </div>
                            <div class="col-md-6">
                                <label for="billing_phone">Billing Phone/Telephone* :</label>
                                <input type="text" id="billing_phone" class="form-control" name="billing_phone"
                                    value="{{ $customer->billing_phone }}" required />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="billing_email">Billing Email* :</label>
                                <input type="email" id="billing_email" class="form-control" name="billing_email"
                                    value="{{ $customer->billing_email }}" required />
                            </div>
                            <div class="col-md-6">
                                <label for="status">Status* :</label>
                                <select id="status" name="status" class="form-control" required>
                                    <option value="Active" {{ $customer->status == 'Active' ? 'selected' : '' }}>Active
                                    </option>
                                    <option value="Inactive" {{ $customer->status == 'Inactive' ? 'selected' : '' }}>
                                        Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <input type="hidden" id="customerID" value="{{$customer->id}}">
                                <a href="{{ route('customers.index') }}" class="btn btn-info">Cancel</a>
                                <a class="btn btn-primary" id="btnSubmit" style="color:#fff">Update</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>


    <script>
        $("#btnAttention").click(function(){
            $("#newAttentionBox").show();
            $("#newAttentionPerson").val('');
        });

        $("#btnAttentionSave").click(function(){
            let customerId = $("#customer_id").val();
            let newAttentionPerson = $("#newAttentionPerson").val();
            newAttentionPerson = newAttentionPerson.trim();
            if(newAttentionPerson==''){
                show_toastr('error', 'Enter attention person name');
                $("#newAttentionPerson").focus();
                return false;
            }else{
                $.ajax({
                    url: '{{url("add-new-attention")}}',
                    method: 'POST',
                    data: {
                        customer_id: customerId,
                        new_attention_person: newAttentionPerson,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if(response.status===3){
                            show_toastr('success', 'Attention person added');
                            $('#attention_person').html(response.dropdown);
                            $('#newAttentionPerson').val('');
                            $("#newAttentionBox").hide();
                        }else{
                            show_toastr('error', 'Attention person exist, check list');
                        }
                    },
                    error: function(xhr, status, error) {
                        show_toastr('error', 'Attention person not added');
                    }
                });
            }
        });
    </script>

    <script>
        $('#btnSubmit').click(function() {
            let valid = true;

            $('#customerForm').find('input[required]').each(function() {
                if (!$(this).val()) {
                    valid = false;
                    show_toastr('error', 'Missing required field');
                    $(this).focus();
                    return false;
                }
            });

            if (valid) {
                // const phoneRegex = /^01[3-9][0-9]{8}$/;

                // const phone = $('#phone').val();
                // const billingPhone = $('#billing_phone').val();
                // const accountPhone = $('#account_phone').val();

                // if (!phoneRegex.test(phone)) {
                //     valid = false;
                //     show_toastr('error', 'Phone number must be valid.');
                //     $('#phone').focus();
                //     return false;
                // }

                // if (!phoneRegex.test(billingPhone)) {
                //     valid = false;
                //     show_toastr('error', 'Billing phone must be valid.');
                //     $('#billing_phone').focus();
                //     return false;
                // }


                if (valid) {
                    var autoAcNo = $('#autoAcNo').val();
                    if (autoAcNo == '') {
                        show_toastr('error', 'Missing required field');
                        return false;
                    } else {
                        $.ajax({
                            type: 'GET',
                            url: '{{url("checkAccountCustomer")}}/' + '{{ $customer->id }}' + '/' + autoAcNo,
                            success: function(data) {
                                if (data == '1') {
                                    $('#customerForm').attr("method", "post");
                                    $('#customerForm').attr("action", "{{ route('customers.update', $customer->id) }}");
                                    $('#customerForm').submit();
                                } else {
                                    show_toastr('error', 'Account Customer already used, please select another');
                                    return false;
                                }
                            }
                        });
                    }
                }
            }
        });
    </script>


@endsection
