<style>
    .text-right {
        text-align: right;
    }

    .table-responsive {
        max-height: 380px; /* Adjust the height as needed to show around 10 rows */
        overflow-y: auto;
    }

    .table thead th {
        position: sticky;
        top: 0;
        z-index: 1;
    }
    .footer-td{
        font-weight: bold;
    }
</style>

<script>
    $('#exampleModalLabel').text("Deal: {{$deal->name}}");
</script>
<div class="container mt-2">
    <div class="table-responsive" style="padding-left: 10px; padding-right: 10px;">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Project Name</th>
                    <th>Budget</th>
                    <th>Expense</th>
                    <th>Collection</th>
                    <th>Remaining</th>
                </tr>
            </thead>
            <tbody>
                @if($projects)

                    @php
                        $grandPrice = 0;
                        $grandDealExpense = 0;
                        $grandCollection = 0;
                        $grandRemaining = 0;
                    @endphp

                    @foreach($projects as $row)
                    <tr>

                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->project_name }}</td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat($row->budget) }}</td>
                        <td class="text-right">
                        @php
                            $projectId = $row->id;
                            $projectBudget = $row->budget;
                            $grandPrice = $grandPrice+$row->budget;

                            $totalMainExpenseAmt = 0;
                            $totalOtherExpenseAmt = 0;
                            $totalCollectionAmt = 0;
                            $expenseInfo = DB::table('bills')->where('project_id', $projectId)->get();
                            $otherExpenseInfo = DB::table('other_expenses')->where('module_id', $projectId)->where('module', 'project')->get();
                            $collectionInfo = DB::table('collection_chds')->where('project_id', $projectId)->get();
                        @endphp

                        @if($expenseInfo)
                            @foreach($expenseInfo as $row)
                                @php
                                    $expensePay = DB::table('bill_payments')->where('bill_id', $row->id)->first();
                                @endphp

                                @if($expensePay)
                                    @php
                                        $totalMainExpenseAmt = $totalMainExpenseAmt + $expensePay->amount;
                                    @endphp
                                @endif
                            @endforeach
                        @endif

                        @if($otherExpenseInfo)
                            @foreach($otherExpenseInfo as $row)
                                @php
                                    $totalOtherExpenseAmt = $totalOtherExpenseAmt + $row->amount;
                                @endphp
                            @endforeach
                        @endif

                        @if($collectionInfo)
                            @foreach($collectionInfo as $row)
                                @php
                                    $totalCollectionAmt = $totalCollectionAmt + $row->collection_amount;
                                @endphp

                            @endforeach
                        @endif
                        @php
                            $totalExpense = $totalMainExpenseAmt+$totalOtherExpenseAmt;
                            $totalRemainingAmt = $projectBudget-($totalExpense+$totalCollectionAmt);

                            $grandDealExpense = $grandDealExpense+$totalExpense;
                            $grandCollection = $grandCollection+$totalCollectionAmt;
                            $grandRemaining = $grandRemaining+$totalRemainingAmt;
                        @endphp
                        {{\App\Models\Settings::priceFormat($totalExpense)}}
                        </td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat($totalCollectionAmt)}}</td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat($totalRemainingAmt)}}</td>

                    </tr>
                    @endforeach
                    <tr class="footer-td">
                        <td class="text-right" colspan="2">Total</td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat($grandPrice)}}</td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat ($grandDealExpense) }}</td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat ($grandCollection) }}</td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat ($grandRemaining) }}</td>

                    </tr>
                @else
                    <tr>
                        <td colspan="6">No data found</td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
