<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            color: #333333;
            margin: 0;
            padding: 20px;
        }
        .container {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: 0 auto;
        }
        .header {
            text-align: center;
            padding: 10px 0;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 10px 10px 0 0;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 20px;
        }
        .content h2 {
            color: #007bff;
            font-size: 20px;
            margin-bottom: 10px;
        }
        .content p {
            margin: 8px 0;
            font-size: 16px;
        }
        .content p span {
            font-weight: bold;
            color: #555555;
        }
        .content .highlight {
            color: #d9534f;
            font-weight: bold;
        }
        .footer {
            text-align: center;
            padding: 10px 0;
            background-color: #f1f1f1;
            color: #777777;
            border-radius: 0 0 10px 10px;
            margin-top: 20px;
        }
        .footer p {
            margin: 0;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Bill Rejection Notice</h1>
        </div>
        <div class="content">
            <h2>Reject Note: {{ $reject_note }} </h2>
            <br>
            <p>We regret to inform that bill <span class="highlight">#{{ $bill_no }}</span> has been rejected.</p>
            <p><span>Customer:</span>{{ $customer_id }}</p>
            <p><span>Particulars:</span> {{ $particulars }}</p>
            <p><span>Total Amount:</span> {{ $convertion_totalamount }}</p>
            <p><span>Billing Period:</span> {{ $start_date }}  to  {{ $end_date }}</p>
            <p><span>Bill Type:</span> {{ $bill_type }}</p>
            <p><span>VAT Status:</span> {{ $vat_status }}</p>
            <p><span>VAT Percentage:</span> {{ $vat_percent }}</p>

        </div>
        <div class="footer">
            <p>If you have any questions or need further assistance, please contact our support team.</p>
            <p>Thank you for your understanding.</p>
        </div>
    </div>
</body>
</html>
