@extends('layouts.app')

@section('title')
    Instant Bill
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Create Instant Bill</h4>
        </div>
    </div>

    <form name="invoiceForm" id="invoiceForm" autocomplete="off">
        <div class="row">
            <div class="col-md-12">
                <div class="x_panel main-form">
                    <div class="x_title">
                        <h5>Instant Bill Entry</h5>
                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content" style="padding:0">

                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <label for="customer_id">Customer* :</label>
                                <select id="customer_id" name="customer_id" class="form-control select2" required>
                                    <option value="">--Select Customer--</option>
                                    @if ($customers)
                                        @foreach ($customers as $row)
                                        <option value="{{$row['autoAcNo']}}"
                                            data-extra="{{$row['divCode']}}">{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <input type="hidden" id="customerName" name="customerName">
                            </div>
                            <div class="col-md-6">
                                <label for="vat_status">VAT Status :</label>
                                <select id="vat_status" name="vat_status" class="form-control select2">
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="invoice_date">Invoice Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="invoice_date" id="invoice_date" placeholder="dd/mm/yyyy"
                                        value="{{date('d/m/Y')}}" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label for="department_id">Department* :</label>
                                <select id="department_id" name="department_id" class="form-control readmode" required>
                                    <option value=""></option>
                                    @if ($depts)
                                        @foreach ($depts as $row)
                                        <option value="{{$row['divCode']}}">{{$row['divName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="subject_id">Subject* :</label>
                                <select id="subject_id" name="subject_id" class="form-control select2" required>
                                    <option value="">--Select--</option>
                                    @if ($subjects)
                                        @foreach ($subjects as $row)
                                            <option value="{{ $row->id }}">{{ $row->bill_subject }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="year">Year :</label>
                                <select id="year" name="year" class="form-control">
                                    @for ($year = 2000; $year <= date('Y'); $year++)
                                        @if ($year == date('Y'))
                                            <option value="{{ $year }}" selected>{{ $year }}</option>
                                        @else
                                            <option value="{{ $year }}">{{ $year }}</option>
                                        @endif
                                    @endfor
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="month">Month :</label>
                                <select id="month" name="month" class="form-control">
                                    <option value="January" {{ date('F') == 'January' ? 'selected' : '' }}>January</option>
                                    <option value="February" {{ date('F') == 'February' ? 'selected' : '' }}>February
                                    </option>
                                    <option value="March" {{ date('F') == 'March' ? 'selected' : '' }}>March</option>
                                    <option value="April" {{ date('F') == 'April' ? 'selected' : '' }}>April</option>
                                    <option value="May" {{ date('F') == 'May' ? 'selected' : '' }}>May</option>
                                    <option value="June" {{ date('F') == 'June' ? 'selected' : '' }}>June</option>
                                    <option value="July" {{ date('F') == 'July' ? 'selected' : '' }}>July</option>
                                    <option value="August" {{ date('F') == 'August' ? 'selected' : '' }}>August</option>
                                    <option value="September" {{ date('F') == 'September' ? 'selected' : '' }}>September
                                    </option>
                                    <option value="October" {{ date('F') == 'October' ? 'selected' : '' }}>October</option>
                                    <option value="November" {{ date('F') == 'November' ? 'selected' : '' }}>November
                                    </option>
                                    <option value="December" {{ date('F') == 'December' ? 'selected' : '' }}>December
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <label for="remarks">Remarks :</label>
                                <textarea id="remarks" class="form-control" name="remarks"></textarea>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        {{-- table --}}
        <div class="row">
            <div class="col-md-12">
                <table id="datatable-buttons22" class="table table-striped table-bordered gridTable" style="width:100%">
                    <thead>
                        <tr>
                            <th style="width:280px;text-align:left;">Particulars</th>
                            <th style="width:80px;">Bill Qty</th>
                            <th>Unit<br>Price</th>
                            <th>Total<br>Price</th>
                            <th>VAT<br>Rate(%)</th>
                            <th>Total<br>VAT</th>
                            <th>Total<br>Value</th>
                            {{-- <th></th> --}}
                        </tr>
                    </thead>

                    <tbody id="gridBody">
                        <tr>
                            <td><input type="text" class="form-control particulars" name="particulars[]"
                                    style="text-align:left;"></td>
                            <td><input type="number" class="form-control qty" name="qty[]"
                                    onkeyup="calcGrid($(this))">
                            </td>
                            <td><input type="number" class="form-control unitPrice" name="unit_price[]"
                                    onkeyup="calcGrid($(this))"></td>
                            <td><input type="number" class="form-control totalPrice readmode" name="total_price[]"></td>
                            <td><input type="number" class="form-control vatRate" name="vat_rate[]"
                                    onkeyup="calcGrid($(this))"></td>
                            <td><input type="number" class="form-control totalVat readmode" name="total_vat[]"></td>
                            <td><input type="number" class="form-control totalValue readmode" name="total_value[]"></td>
                            {{-- <td></td> --}}
                        </tr>
                    </tbody>

                    {{-- <tfoot>
                        <tr>
                            <td colspan="3" style="text-align: center; font-weight:bold;">Grand Total</td>
                            <td><input type="number" name="grandTotal" class="form-control grandTotal readmode"></td>
                            <td colspan="1"></td>
                            <td><input type="number" name="grandVat" class="form-control grandVat readmode"></td>
                            <td><input type="number" name="netTotal" class="form-control netTotal readmode"></td>
                            <td>
                                <a class="btn btn-sm btn-success text-light" id="addMore" data-bs-toggle="tooltip"
                                    title="Add More">
                                    <i class="fa fa-plus"></i>
                                </a>
                            </td>
                        </tr>
                    </tfoot> --}}
                </table>

                <div style="text-align:center;width: 100%;">
                    <br>
                    <a href="{{ route('instantInvoice.index') }}" class="btn btn-info">Cancel</a>
                    <button class="btn btn-primary" id="btnSubmit">Generate Invoice</button>
                </div>

            </div>

        </div>
    </form>

    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }

        .gridTable thead th {
            padding: 5px;
        }

        .gridTable tbody td,
        .gridTable tfoot td {
            padding: 3px !important;
            vertical-align: middle;
        }

        .gridTable th,
        .gridTable td,
        .gridTable th input,
        .gridTable td input {
            text-align: right;
        }

        .grandTotal,
        .grandVat,
        .netTotal {
            margin: 0px;
            font-weight: bold;
        }

        .gridTable tfoot tr td,
        .gridTable tfoot input {
            background-color: #a5f6a5;
        }
    </style>
@endsection

@section('script')
    <script>
        $('#customer_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#customerName').val(selText);
            var divCode = selOption.data('extra');
            $('#department_id').val(divCode).trigger('change');
        });

        $('#btnSubmit').click(function() {

            if ($('#customer_id').val() == '' || $('#department_id').val() == '' || $('#subject_id').val() == '') {
                show_toastr('error', 'Missing required fields');
                return false;
            }

            var isParticularBlank = false;
            $(".particulars").each(function() {
                if (this.value.trim().length == 0) {
                    isParticularBlank = true;
                }
            });
            if (isParticularBlank) {
                show_toastr('error', 'Please Enter Particulars');
                return false;
            }

            var isQtyBlank = false;
            $(".qty").each(function() {
                if (isNaN(this.value) || this.value == "" || this.value == 0) {
                    isQtyBlank = true;
                }
            });
            if (isQtyBlank) {
                show_toastr('error', 'Please Enter Bill Qty');
                return false;
            } else {
                // proceed to submit
                $('#invoiceForm').attr('method', 'post');
                $('#invoiceForm').attr('action', '{{ route('instantInvoice.store') }}');
                $("#invoiceForm").submit();
            }

        });

        $(document).on('click', '#addMore', function() {

            $('#gridBody').append('<tr>' +
                '<td><input type="text" class="form-control particulars" name="particulars[]" style="text-align:left;"></td>' +
                '<td><input type="text" class="form-control qty" name="qty[]" onkeyup="calcGrid($(this))"></td>' +
                '<td><input type="text" class="form-control unitPrice" name="unit_price[]" onkeyup="calcGrid($(this))"></td>' +
                '<td><input type="text" class="form-control totalPrice readmode" name="total_price[]"></td>' +
                '<td><input type="text" class="form-control vatRate" name="vat_rate[]" onkeyup="calcGrid($(this))"></td>' +
                '<td><input type="text" class="form-control totalVat readmode" name="total_vat[]"></td>' +
                '<td><input type="text" class="form-control totalValue readmode" name="total_value[]"></td>' +
                '<td><a class="btn btn-sm btn-danger btnDelete text-light" data-bs-toggle="tooltip" title="Delete">' +
                '<i class="fa fa-times"></i></a></td></tr>');
            gridTotal();
        });

        $(document).on('click', '.btnDelete', function() {
            if (confirm('are you want to delete this!')) {
                $(this).closest('tr').remove();
                gridTotal();
            }
        });

        function calcGrid(e) {
            var thisRow = e.closest('tr');
            var qty = parseInt(thisRow.find('.qty').val());
            var unitPrice = parseFloat(thisRow.find('.unitPrice').val());
            var vatRate = parseFloat(thisRow.find('.vatRate').val());
            // var unitVat = parseFloat(thisRow.find('.unitVat').val());

            if (isNaN(qty) || qty == "") {
                qty = 0;
            }
            if (isNaN(unitPrice) || unitPrice == "") {
                unitPrice = 0;
            }
            if (isNaN(vatRate) || vatRate == "") {
                vatRate = 0;
            }
            // if(isNaN(unitVat) || unitVat==""){ unitVat = 0; }

            var totalPrice = qty * unitPrice;
            var totalVat = (vatRate * totalPrice) / 100;
            // unitVat = totalVat/qty;
            var totalValue = totalPrice + totalVat;

            thisRow.find('.totalPrice').val(totalPrice.toFixed(2));
            // thisRow.find('.unitVat').val(unitVat.toFixed(2));
            thisRow.find('.totalVat').val(totalVat.toFixed(2));
            thisRow.find('.totalValue').val(totalValue.toFixed(2));
            gridTotal();
        }

        function gridTotal() {
            var totalPrice = 0;
            $(".totalPrice").each(function() {
                if (!isNaN(this.value) && this.value.length != 0) {
                    totalPrice += parseFloat(this.value);
                }
            });
            $('.grandTotal').val(totalPrice.toFixed(2));

            var totalVat = 0;
            $(".totalVat").each(function() {
                if (!isNaN(this.value) && this.value.length != 0) {
                    totalVat += parseFloat(this.value);
                }
            });
            $('.grandVat').val(totalVat.toFixed(2));

            var totalValue = 0;
            $(".totalValue").each(function() {
                if (!isNaN(this.value) && this.value.length != 0) {
                    totalValue += parseFloat(this.value);
                }
            });
            $('.netTotal').val(totalValue.toFixed(2));
        }
    </script>
@endsection
