
@extends('layouts.app')

@section('title')
    Duplicate Invoices
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Duplicate Invoices</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <form action="{{ route('duplicate.invoice') }}" method="GET">
                        <div class="row d-flex align-items-end">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="start_date">Invoice Start Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="start_date" id="start_date" value="{{ request('start_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="end_date">Invoice End Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="end_date" id="end_date" value="{{ request('end_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="bill_type">Bill Type :</label>
                                    <select id="bill_type" name="bill_type" class="form-control select2">
                                        <option value="">Bill Type</option>
                                        <option value="One Time" {{ request('bill_type') == 'One Time' ? 'selected' : '' }}>
                                            One Time</option>
                                        <option value="Monthly" {{ request('bill_type') == 'Monthly' ? 'selected' : '' }}>
                                            Monthly</option>
                                        <option value="Quarterly"
                                            {{ request('bill_type') == 'Quarterly' ? 'selected' : '' }}>Quarterly</option>
                                        <option value="Half Yearly"
                                            {{ request('bill_type') == 'Half Yearly' ? 'selected' : '' }}>Half Yearly
                                        </option>
                                        <option value="Yearly" {{ request('bill_type') == 'Yearly' ? 'selected' : '' }}>
                                            Yearly</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="customer" class="form-label">Customer</label>
                                    <select name="customer" id="customer" class="form-control select2">
                                        <option value="">Select customer</option>
                                        @foreach ($customers as $customer)
                                            <option value="{{ $customer->id }}"
                                                {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->customer_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="invoice_no" class="form-label">Invoice No</label>
                                    <input type="text" name="invoice_no" id="invoice_no" class="form-control"
                                        value="{{request('invoice_no')}}" placeholder="Invoice No">
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <button class="btn btn-primary btn-block" type="submit">Filter</button>
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <a href="{{ route('duplicate.invoice') }}" class="btn btn-danger btn-block">Clear</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <form action="{{ route('duplicate.invoice') }}" method="GET" class="num_filter px-4">
        <label for="per_page">Show</label>
        <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
            <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
            <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
            <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
            <option value="{{ $groupedBills->total() }}" {{ $perPage == $groupedBills->total() ? 'selected' : '' }}>All</option>
        </select>
        Entries
        @foreach (request()->except('per_page', 'page') as $key => $value)
            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
        @endforeach
    </form>


<form id="billListForm">
@csrf
<div class="row">
    <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>Sl</th>
                <th>Invoice No</th>
                <th>Invoice Date</th>
                <th>Customer</th>
                <th>Bill Subject</th>
                <th>Group</th>
                <th>Total<br>Amount</th>
                <th>Action</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($groupedBills as $row)
                <tr>
                    <td>{{ $loop->iteration + ($groupedBills->currentPage() - 1) * $groupedBills->perPage() }}</td>
                    <td><nobr>{{ $row->invoice_no }}</nobr></td>
                    <td>{{ $row->invoice_date }}</td>
                    <td>{{ \App\Models\Customer::find($row->customer_id)->customer_name }}</td>
                    <td>{{ $row->bill_subject_desc }}</td>
                    {{-- <td>{{ ($row->bill_subject_id)? \App\Models\BillSubject::find($row->bill_subject_id)->bill_subject:'' }}</td> --}}
                    <td class="text-center">{{ $row->bill_group }}</td>
                    <td class="text-right">{{ priceFormat($row->total_vat_amount) }}</td>
                    <td>
                        @php
                            $invNO = str_replace("/","_",$row->invoice_no)
                        @endphp
                        {{-- <a href="{{ route('duplicate.invoice.view', ['bill_ids' => $row->bill_ids]) }}" target="_blank" class="btn btn-info btn-sm">Invoice</a> --}}
                        <a href="{{ route('duplicate.invoice.view', ['invNO' => $invNO]) }}" target="_blank" class="btn btn-info btn-sm">Invoice</a>
                    </td>

                </tr>
            @endforeach
        </tbody>
    </table>
</div>
</form>

<div class="row">
    <div class="col-md-12 d-flex justify-content-between">
        <div>
            Showing {{ $groupedBills->firstItem() }} to {{ $groupedBills->lastItem() }} of {{ $groupedBills->total() }} entries
        </div>
        <div>
            {{ $groupedBills->appends(request()->except('page'))->links('vendor.pagination.custom-pagination') }}
        </div>
    </div>
</div>



    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>




    <script>
        // Select/Deselect All Checkboxes
        document.getElementById('select-all').onclick = function() {
            var checkboxes = document.getElementsByName('selected_bills[]');
            for (var checkbox of checkboxes) {
                checkbox.checked = this.checked;
            }
        };


    </script>



<script>
    function allInvoicePrint(status) {
    var selectedBills = $('input[name="selected_bills[]"]:checked').map(function() {
        return this.value;
    }).get();

    if (selectedBills.length > 0) {
        var form = $('#billListForm');
        $('<input>').attr({
            type: 'hidden',
            name: 'selected_bills',
            value: JSON.stringify(selectedBills)
        }).appendTo(form);

        $('#status').val(status);
        form.attr("method", "post");
        form.attr("action", "{{ route('all.invoices.groupbywise') }}");
        form.submit();
    } else {
        // Redirect to the same route without selected bills to show all invoices
        var queryString = new URLSearchParams(window.location.search).toString();
        window.location.href = "{{ route('all.invoices.groupbywise.allshow') }}?" + queryString + "&show_all=true";
    }
}

</script>



<script>
    $(document).ready(function () {
        const startDateInput = $('#start_date');
        const endDateInput = $('#end_date');

        startDateInput.on('change', function () {
            const startDate = startDateInput.val();
            if (startDate) {
                endDateInput.attr('min', startDate);
            }
        });

        endDateInput.on('change', function () {
            const startDate = new Date(startDateInput.val().split('/').reverse().join('-'));
            const endDate = new Date(endDateInput.val().split('/').reverse().join('-'));

            if (endDate < startDate) {
                show_toastr('error', 'End Date must be greater than or equal to Start Date');
                endDateInput.val('');
            }
        });
    });
</script>



<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .container {
        flex: 1;
        overflow-y: auto;
    }

    .row {
        flex-grow: 1;
    }

    .table-responsive {
        max-height: calc(100vh - 250px);
        overflow-y: auto;
    }

    #datatable-buttons th, #datatable-buttons td {
        font-size: 13.5px;
    }
</style>


@endsection
