<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Duplicate Invoice</title>
</head>
<body>
    @php
        $settings = App\Models\Settings::get_settings();
        $totalINV = count($INVOICE_NO);
        $x = 0;
    @endphp

    @foreach ($INVOICE_NO as $INV_NO)

        @php $x++; @endphp

        @php
            $bills = \App\Models\BillProcess::select('customer_id', 'currency', 'bill_subject_desc', 'total_amount',
                'vat_amount', 'total_amount_vat', 'invoice_no', 'invoice_date', 'attention_person', 'particulars',
                'installation_date', 'ref_no', 'ref_date', 'qty', 'vat_percent', 'unit_price_vat')
                ->where('invoice_no', $INV_NO)
                ->get();

            // update print count
            \App\Models\BillProcess::where('invoice_no', $INV_NO)
                ->increment('duplicate_print_count');

            $customer = \App\Models\Customer::select('id','customer_name','address','phone','bin_no','billing_name','billing_phone')
                ->where('id', $bills[0]->customer_id)->first();

            $currency = $bills[0]->currency;
            $billSubjectDesc = $bills[0]->bill_subject_desc;

            $totalAmountWholeValue = $bills->sum('total_amount');
            $totalVatWholeValue = $bills->sum('vat_amount');
            $alltotalammount = $bills->sum('total_amount_vat');
        @endphp

        {{-- INVOICE TOP PAGE --}}

        <div class="x_content" style="padding:0;padding-bottom:10px;" id="printableArea1">
            <div style="position: absolute;color: #a09d9d;font-size: 30px;">
                Duplicate
            </div>
            <div class="row d-flex align-items-center">
                <div style="color: #b9b6b6;font-size: 30px;text-align:right;width: 100%;margin-bottom:-15px;">
                    {{-- <h6 style="font-family: SolaimanLipi !important">যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ </h6> --}}
                    <img src="{{ public_path('images/invoice-slogan.jpg') }}" alt="Invoice Logo" style="width: 200px;">
                </div>

                <div class="col-6">
                </div>
                <div class="col-6 justify-content-end">
                    {{-- <div style="text-align: right;margin-bottom:-21px;"> --}}
                    <div style="text-align: right;margin-bottom:-30px;">
                        {{-- <h6 class="text-right border d-inline-block mb-0 customer-tag">Customer Copy</h6> --}}
                        <div class="text-right border d-inline-block mb-0 customer-tag">Customer Copy</div>
                    </div>
                </div>
            </div>
            <h5 class="text-center" style="font-size: 15px !important;"> <strong>INVOICE</strong></h5>
            {{-- <div class="row" style="border-top: 1px solid #b9b6b6; padding-top:6px;"> --}}
            <div class="row" style="padding-top:6px;">
                <div class="col-md-6 float-left">
                <h4 style="font-weight:bold;font-size:14px !important;">{{ $customer->customer_name }}</h4>
                <p style="margin-top:-3px !important">{{ $customer->address }}</p>
                <p>BIN - {{ $customer->bin_no }}</p>
                </div>
                <div class="col-md-6 text-right float-left">
                <p class=""><strong class=""> Invoice No: </strong> {{ $bills[0]->invoice_no }} </p>
                <p class=""><strong class=""> Invoice Date: </strong> {{ $bills[0]->invoice_date }} </p>
                </div>
                <div class="clearfix"></div>
            </div>

            <div class="row mt-1">
                <div class="col-md-12">
                    <p><strong class="">Attention:</strong> {{ $bills[0]->attention_person}}</p>
                    <table class="table table-bordered mt-2 invoice-table first-table">
                        <thead>
                            <tr>
                                <th class="text-center">Sl.</th>
                                <th class="text-center">Description</th>
                                <th class="text-center">Amount (in {{ $currency }})</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="text-center">1</td>
                                <td> {{ $billSubjectDesc }} </td>
                                <td class="text-right">{{ priceFormat($totalAmountWholeValue) }}</td>
                            </tr>
                            <tr>
                                <td class="text-center">2</td>
                                <td>Value Added Tax</td>
                                <td class="text-right">{{ priceFormat($totalVatWholeValue) }}</td>
                            </tr>
                            <tr>
                                <td class="text-center">3</td>
                                <td>Payment Terms:
                                    </br>
                                    100% of the invoice is payable by A/C
                                    </br>
                                    Payee Cheque/Pay Order favoring "{{ $settings['company_name'] }}"
                                    </br>
                                    BIN - {{ $settings['company_bin'] }} & TIN - {{ $settings['company_tin'] }}
                                </td>
                                <td></td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right"><strong>Total:</strong></td>

                                <td class="text-right"><strong> {{ number_format((float)$alltotalammount, 2) }} </strong></td>
                            </tr>
                        </tfoot>
                    </table>

                    <p><strong class=""> Total (In Word):
                        {{ ucwords(\App\Models\Settings::convertToWords((int)$alltotalammount)) . ' ' . $currency }}
                        Only</strong></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-2"><strong class="">For Bank Transfer:</strong></p>
                    <div class="border p-2 black">
                        <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}
                        </br>
                        <strong>Account No:</strong> {{ $settings['bank_account_no'] }}
                        </br>
                        <strong>Bank Name:</strong> {{ $settings['bank_name'] }}
                        </br>
                        <strong>Branch Name:</strong> {{ $settings['branch_name'] }}
                        </br>
                        <strong>Routing No:</strong> {{ $settings['routing_no'] }}
                        </br>
                        <strong>Swift Code:</strong> {{ $settings['swift_code'] }}
                    </div>
                </div>
            </div>
            <div class="row" style="margin-top: 90px;">
                <div class="col-md-12">
                    <p style="display: inline-block; margin-left: 20px;">
                        ........................................
                        </br>
                        Authorized Signature
                    </p>
                    <p style="display: inline-block; margin-right: 20px; float: right;">
                        ........................................
                        <br>
                        Authorized Signature
                    </p>
                </div>
            </div>
        </div>
        <div style="page-break-before: always;"></div>

        {{-- invoice breakdown --}}
        <div class="x_content" style="padding:0;padding-bottom:10px;" id="printableArea2">
            <div style="position: absolute;color: #a09d9d;font-size: 30px;">
                Duplicate
            </div>
            <div class="row d-flex align-items-center">
                <div style="color: #b9b6b6;font-size: 30px;text-align:right;width: 100%;margin-bottom:-15px;">
                    {{-- <h6 style="font-family: SolaimanLipi !important">যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ </h6> --}}
                    <img src="{{ public_path('images/invoice-slogan.jpg') }}" alt="Invoice Logo" style="width: 200px;">
                </div>

                <div class="col-6">
                </div>
                <div class="col-6 justify-content-end">
                    {{-- <div style="text-align: right;margin-bottom:-21px;"> --}}
                    <div style="text-align: right;margin-bottom:-30px;">
                        {{-- <h6 class="text-right border d-inline-block mb-0 customer-tag">Customer Copy</h6> --}}
                        <div class="text-right border d-inline-block mb-0 customer-tag">Customer Copy</div>
                    </div>
                </div>
            </div>
            <h5 class="text-center" style="font-size: 15px !important;"> <strong>INVOICE</strong></h5>
            {{-- <div class="row" style="border-top: 1px solid #b9b6b6; padding-top:6px;"> --}}
            <div class="row" style="padding-top:6px;">
                <div class="col-md-6 float-left">
                <h4 style="font-weight:bold;font-size:14px !important;">{{ $customer->customer_name }}</h4>
                <p style="margin-top:-3px !important">{{ $customer->address }}</p>
                <p>BIN - {{ $customer->bin_no }}</p>
                </div>
                <div class="col-md-6 text-right float-left">
                <p class=""><strong class=""> Invoice No: </strong> {{ $bills[0]->invoice_no }} </p>
                <p class=""><strong class=""> Invoice Date: </strong> {{ $bills[0]->invoice_date }} </p>
                </div>
                <div class="clearfix"></div>
            </div>

            <div class="row mt-1">
                <div class="col-md-12">
                    <p><strong class=""></strong> Subject: {{ $billSubjectDesc }} </p>

                    <table class="table table-bordered mt-2 invoice-table second-table">
                        <thead>
                            <tr>
                                <th class="text-center">Sl.</th>
                                <th class="text-center">Particulars</th>
                                <th class="text-center little-padding">Date of<br>Inst.</th>
                                <th class="text-center little-padding">Ref No</th>
                                <th class="text-center little-padding">Ref Date</th>
                                <th class="text-center little-padding">Qty</th>
                                <th class="text-center little-padding">VAT<br>(%)</th>
                                <th class="text-center little-padding">Unit<br>Price</th>
                                <th class="text-center little-padding">Total<br>Unit Price</th>
                                <th class="text-center little-padding">VAT<br>Amount</th>
                                <th class="text-center little-padding">Total Price</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach($bills as $bill)
                                @php
                                    $vatRate = $bill->vat_percent ?? 0
                                @endphp

                                <tr>
                                    <td class="text-center">{{ $loop->iteration }}</td>
                                    <td style="width:176px;">{{ $bill->particulars }}</td>
                                    <td class="text-center little-small little-padding">{{ $bill->installation_date }}</td>
                                    <td class="little-small little-padding" style="width:45px !important;word-wrap: break-word; overflow-wrap: break-word; white-space: normal;">
                                        @php
                                            $string = $bill->ref_no;
                                            $formattedString = preg_replace('/([\/_])/', '$1 ', $string);
                                        @endphp
                                        {{ $formattedString }}
                                    </td>
                                    <td class="text-center little-small little-padding">{{ $bill->ref_date }}</td>
                                    <td class="text-center little-small little-padding">{{ $bill->qty }}</td>
                                    <td class="text-right little-small little-padding">{{ priceFormat($vatRate) }}%</td>
                                    <td class="text-right little-small little-padding">{{ priceFormat($bill->unit_price_vat) }}</td>
                                    <td class="text-right little-small little-padding">{{ priceFormat($bill->total_amount) }}</td>
                                    <td class="text-right little-small little-padding">{{ priceFormat($bill->vat_amount) }}</td>
                                    <td class="text-right little-small little-padding">{{ priceFormat($bill->total_amount_vat) }}</td>
                                </tr>
                            @endforeach

                        </tbody>
                        <tfoot>
                            {{-- <tr>
                                <td class="text-right" colspan="8"><strong>Total:</strong></td>
                                <td class="text-right">
                                    <strong>{{ priceFormat($totalAmountWholeValue) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong>{{ priceFormat($totalVatWholeValue) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong>{{ priceFormat($alltotalammount) }}</strong>
                                </td>
                            </tr> --}}
                            <tr>
                                <td class="text-right" colspan="8"><strong>Total:</strong></td>
                                <td class="text-right">
                                    <strong>{{ number_format((float)$totalAmountWholeValue, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format((float)$totalVatWholeValue, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format((float)$alltotalammount, 2) }}</strong>
                                </td>
                            </tr>
                        </tfoot>
                    </table>

                    <p class=""><strong class=""> Total (In Word):
                        {{ ucwords(\App\Models\Settings::convertToWords((int)$alltotalammount)) . ' ' . $currency }}
                        Only</p></strong>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-1"><strong class="">For Bank Transfer:</strong></p>
                    <div class="border p-2 black">
                        <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}
                        </br>
                        <strong>Account No:</strong> {{ $settings['bank_account_no'] }}
                        </br>
                        <strong>Bank Name:</strong> {{ $settings['bank_name'] }}
                        </br>
                        <strong>Branch Name:</strong> {{ $settings['branch_name'] }}
                        </br>
                        <strong>Routing No:</strong> {{ $settings['routing_no'] }}
                        </br>
                        <strong>Swift Code:</strong> {{ $settings['swift_code'] }}
                    </div>

                    {{-- <div class="mt-2">
                        <strong class="">Payment Terms:</strong> <br>
                        1. 100% of the invoice is payable by A/C <br>
                        2. Payee Cheque/Pay Order favoring "{{ $settings['company_name'] }}" <br>
                        3. BIN - {{ $settings['company_bin'] }} & TIN - {{ $settings['company_tin'] }}
                    </div> --}}
                </div>
            </div>
            <div class="row" style="margin-top: 80px;">
                <div class="col-md-12">
                    <p style="display: inline-block; margin-left: 20px;">
                        ........................................
                        </br>
                        Authorized Signature
                    </p>
                    <p style="display: inline-block; margin-right: 20px; float: right;">
                        ........................................
                        <br>
                        Authorized Signature
                    </p>
                </div>

            </div>
        </div>

        @if ($x < $totalINV)
            <div style="page-break-before: always;"></div>
        @endif

    @endforeach
<style>
    .x_content, h1, h2, h3, h4, h5, h6, p, .customer-tag{
        /* font-family: arial !important; */
        font-family: Helvetica, sans-serif !important;
    }
    .x_content{
        color:#000 !important;
        font-size:13px;
    }
    .table {
        width: 100%;
        margin-bottom: 1rem;
        color: #212529;
    }
    .invoice-table, .invoice-table th, .invoice-table td {
        border: 0.5px solid #000 !important;
        border-collapse: collapse !important;
        font-size: 12px !important;
        vertical-align: top;
    }
    .invoice-table th {
        background-color: white;
        color: black;
        font-weight: bold;
        padding:2px !important;
        text-align: center;
    }
    .invoice-table td {
        padding:2px 4px !important;
    }
    h1, h2, h3, h4, h5, h6, p, .black{
        color: #000 !important;
        font-size: 13px !important;
    }
    /* p{
        margin-bottom: 1px
    } */
    .text-right{
        text-align: right;
    }
    .text-center{
        text-align: center;
    }

        /* second style */
    .p-2 {
        padding: .5rem !important;
    }
    .mb-2, .my-2 {
        margin-bottom: .5rem !important;
    }
    .pl-3, .px-3 {
        padding-left: 1rem !important;
    }
    .pr-3, .px-3 {
        padding-right: 1rem !important;
    }
    .pb-2, .py-2 {
        padding-bottom: .5rem !important;
    }
    .pt-2, .py-2 {
        padding-top: .5rem !important;
    }
    .mb-0, .my-0 {
        margin-bottom: 0 !important;
    }
    .mt-1, .my-1 {
        margin-top: .25rem !important;
    }
    .mt-2, .my-2 {
        margin-top: .5rem !important;
    }
    .mt-3, .my-3 {
        margin-top: 1rem !important;
    }
    .d-inline-block {
        display: inline-block !important;
    }
    .border {
        border: 1px solid #b9b6b6 !important;
    }
    h1, h2, h3, h4, h5, h6, p, .black {
        color: #000 !important;
        font-size: 13px !important;
    }
    .h6, h6 {
        font-size: 1rem;
    }
    .h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
        margin-bottom: .5rem;
        font-weight: 500;
        line-height: 1.2;
    }
    h1, h2, h3, h4, h5, h6 {
        margin-top: 0;
        margin-bottom: .5rem;
    }
    p{
        margin-top: 0px;
        margin-bottom: 2px;
    }
    .row{
        width:100%;
        /* border:1px solid green; */
    }
    .col-md-6{
        width:50%;
    }
    .float-left{
        float: left;
    }
    .clearfix{
        clear: both;
    }
    .customer-tag{
        padding: 4px 8px;
        font-weight: bold;
    }
    .first-table tbody tr td{
        border-bottom: none !important;
        border-top: none !important;
        padding-bottom: 6px !important;
        vertical-align: top;
    }
</style>

<style>
    @page {
        margin-top: 142px; /* space for every page */
        margin-left: 60px;
        margin-right: 45px;
        margin-bottom: 40px;
    }
</style>

<style>
    .second-table th, .second-table td{
        font-size: 11.5px !important;
    }
    .second-table .little-small{
        font-size: 10.5px !important;
    }
    .second-table .little-padding{
        padding: 2px !important;
    }
</style>


</body>
</html>
