
@extends('layouts.app')

@section('title')
    Process Bill Report
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-4">
            <div class=" mb-0 text-primary" style="font-size:24px;">Process Bill Report</div>
        </div>
        <div class="col-md-4 text-center">
            @php
                $formatedProcessNo = str_replace("/","_",$processNo);
            @endphp
            <a href="{{ route('process-bill-report-pdf', $formatedProcessNo) }}" class="btn btn-warning text-dark">
                <i class="fa fa-print" aria-hidden="true"></i> Print
            </a>
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('report.process-bill-report') }}" class="btn btn-primary">Back</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea2">
                    <div style="color: #000;text-align: right;position: absolute;
                        width: 100%;font-size: 17px !important;padding-right:10px;z-index:999">
                        B.C.Sl. No : {{$processNo}} <br>
                        Status : Posted
                    </div>
                    <div class="row">
                        <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                            <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                            <p style="font-size: 17px !important;">ACCOUNTS DEPARTMENT</p>
                            <p style="font-size: 17px !important;">CUSTOMER WISE INVOICE VALUE (ALL)</p>
                            <p style="font-size: 16px !important;text-transform: uppercase">{{$processInfo->month}} {{$processInfo->year}}</p>
                        </div>
                        <div style="color: #000;width: 100%;padding-left:10px">Printing Date: {{date('d/m/Y')}}</div>

                    </div>

                    <div class="row mt-2">
                        <div class="col-md-12">
                            {{-- <p><strong class="">Subject: </strong>
                                {{ $firstBillSubject ? $firstBillSubject->bill_subject : '-' }}</p> --}}

                            <table class="table table-bordered mt-1 invoice-table">
                                <thead>
                                    <tr>
                                        <th>Invoice No</th>
                                        <th>Invoice Date</th>
                                        <th>Department</th>
                                        <th>Subject</th>
                                        <th>Net Amount</th>
                                        <th>VAT Amount</th>
                                        <th>Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $grand_total_amount = 0;
                                        $grand_vat_amount = 0;
                                        $grand_total_amount_vat = 0;
                                    @endphp
                                    @foreach ($result as $customerId => $data)
                                        {{-- <tr>
                                            <td colspan="8" style="text-align: center; font-weight: bold;">
                                                Customer ID: {{ $customerId }}
                                                Customer Name: {{ $data['customer_name'] }}
                                            </td>
                                        </tr> --}}
                                        @foreach ($data['rows'] as $row)
                                            <tr>
                                                <td>{{ $row->invoice_no }}</td>
                                                <td>{{ $row->invoice_date }}</td>
                                                <td>{{ $row->billDivName }}</td>
                                                <td>{{ $row->bill_subject_desc }}</td>
                                                <td class="text-right">{{ number_format($row->total_amount, 2) }}</td>
                                                <td class="text-right">{{ number_format($row->vat_amount, 2) }}</td>
                                                <td class="text-right">{{ number_format($row->total_amount_vat, 2) }}</td>
                                            </tr>
                                        @endforeach
                                        <tr>
                                            <td colspan="4" style="text-align: right; font-weight: bold;">
                                                {{ $data['customer_name'] }} Total:</td>
                                            <td class="text-right" style="font-weight: bold;">{{ number_format($data['total']['total_amount'], 2) }}</td>
                                            <td class="text-right" style="font-weight: bold;">{{ number_format($data['total']['vat_amount'], 2) }}</td>
                                            <td class="text-right" style="font-weight: bold;">{{ number_format($data['total']['total_amount_vat'], 2) }}</td>
                                        </tr>
                                        @php
                                            $grand_total_amount = $grand_total_amount + $data['total']['total_amount'];
                                            $grand_vat_amount = $grand_vat_amount + $data['total']['vat_amount'];
                                            $grand_total_amount_vat = $grand_total_amount_vat + $data['total']['total_amount_vat'];
                                        @endphp
                                    @endforeach
                                    <tr>
                                        <td colspan="4" style="text-align: right; font-weight: bold;">Grand Total:</td>
                                        <td class="text-right" style="font-weight: bold; background-color: #f0f0f0;">{{ number_format($grand_total_amount,2) }}</td>
                                        <td class="text-right" style="font-weight: bold; background-color: #f0f0f0;">{{ number_format($grand_vat_amount,2) }}</td>
                                        <td class="text-right" style="font-weight: bold; background-color: #f0f0f0;">{{ number_format($grand_total_amount_vat,2) }}</td>
                                    </tr>
                                </tbody>
                            </table>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .x_content{
            /* font-family: arial !important; */
            color:#000 !important;
            font-size:13px;
        }
        .invoice-table, .invoice-table th, .invoice-table td{
            border-collapse: collapse !important;
            font-size:12.5px !important;
        }
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
            border: 1px solid #000 !important;
            border-bottom: 1px solid #000 !important;
            padding:2px !important;
        }
        .invoice-table td {
            border: 1px solid #000 !important;
            border-top: 1px solid #000 !important;
            padding:2px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black{
            color: #000 !important;
            font-size: 13px !important;
        }
        p{
            margin-bottom: 1px
        }
    </style>

@endsection
