
@extends('layouts.app')

@section('title')
    Process Bill Report
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Process Bill Report</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <form action="{{ route('report.process-bill-report') }}" method="GET">
                        <div class="row d-flex align-items-end">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">Start Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="start_date" id="start_date" value="{{ request('start_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">End Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="end_date" id="end_date" value="{{ request('end_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="process_no_format" class="form-label">Process No</label>
                                    <input type="text" name="process_no_format" id="process_no_format" class="form-control"
                                        value="{{request('process_no_format')}}" placeholder="Process No">
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <button class="btn btn-primary btn-block" type="submit">Filter</button>
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <a href="{{ route('report.process-bill-report') }}" class="btn btn-danger btn-block">Clear</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <form action="{{ route('report.process-bill-report') }}" method="GET" class="num_filter px-4">
        <label for="per_page">Show</label>
        <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
            <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
            <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
            <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
            <option value="{{ $groupedBills->total() }}" {{ $perPage == $groupedBills->total() ? 'selected' : '' }}>All</option>
        </select>
        Entries
        @foreach (request()->except('per_page', 'page') as $key => $value)
            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
        @endforeach
    </form>

<div class="row">
    <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>Sl</th>
                <th>Process No</th>
                <th>Process Date</th>
                <th>Action</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($groupedBills as $row)
                @php
                    $processNo = str_replace("/","_",$row->process_no_format);
                @endphp
                <tr>
                    <td>{{ $loop->iteration + ($groupedBills->currentPage() - 1) * $groupedBills->perPage() }}</td>
                    <td>{{ $row->process_no_format }}</td>
                    <td>
                        {{ date('d/m/Y', strtotime($row->recent_created_at)) }}
                    </td>
                    <td>
                        <a href="{{ route('report.process-bill-report.view', $processNo) }}" target="_blank" class="btn btn-info btn-sm">View Details</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
</form>

<div class="row">
    <div class="col-md-12 d-flex justify-content-between">
        <div>
            Showing {{ $groupedBills->firstItem() }} to {{ $groupedBills->lastItem() }} of {{ $groupedBills->total() }} entries
        </div>
        <div>
            {{ $groupedBills->appends(request()->except('page'))->links('vendor.pagination.custom-pagination') }}
        </div>
    </div>
</div>

<style>
    {
        display: inline-block;
        position: absolute;
        z-index: 2;
    }
</style>

<script>
    $(document).ready(function () {
        const startDateInput = $('#start_date');
        const endDateInput = $('#end_date');

        startDateInput.on('change', function () {
            const startDate = startDateInput.val();
            if (startDate) {
                endDateInput.attr('min', startDate);
            }
        });

        endDateInput.on('change', function () {
            const startDate = new Date(startDateInput.val().split('/').reverse().join('-'));
            const endDate = new Date(endDateInput.val().split('/').reverse().join('-'));

            if (endDate < startDate) {
                show_toastr('error', 'End Date must be greater than or equal to Start Date');
                endDateInput.val('');
            }
        });
    });
</script>



<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .container {
        flex: 1;
        overflow-y: auto;
    }

    .row {
        flex-grow: 1;
    }

    .table-responsive {
        max-height: calc(100vh - 250px);
        overflow-y: auto;
    }
</style>


@endsection
