@php
    $settings = App\Models\Settings::get_settings();
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>@yield('title') | {{ $settings['app_name'] }}</title>

    @if (!empty($settings['company_favicon']))
        <link rel="shortcut icon" href="{{ asset('storage/logo/' . $settings['company_favicon']) }}"
            type="image/x-icon">
    @endif

    {!! app('App\Http\Controllers\CacheController')->getHeaderScript() !!}

    @yield('style')

    <!-- Custom Theme Style -->
    <link href="{{ asset('build/css/custom.min.css') }}" rel="stylesheet">

    <script src="{{ asset('vendors/jquery/dist/jquery.min.js') }}"></script>

</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            @include('layouts.sidebar')

            <!-- top navigation -->
            @include('layouts.topNav')
            <!-- /top navigation -->

            <!-- page content -->
            <div class="right_col" role="main">

                @yield('content')
                <!-- top tiles -->

            </div>
            <!-- /page content -->

            <!-- footer content -->
            @include('layouts.footer')
            <!-- /footer content -->
        </div>
    </div>

    <div class="modal fade" id="commonModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-primary" id="exampleModalLabel"></h5>
                    <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="body">
                </div>
            </div>
        </div>
    </div>

    <div class="position-fixed p-3" style="top: 0;right: 0; pointer-events: none; z-index: 99999;">
        <div id="liveToast" class="toast text-white fade" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body"></div>
            </div>
        </div>
    </div>

    {!! app('App\Http\Controllers\CacheController')->getFooterScript() !!}

    @yield('script')

    <!-- Custom Theme Scripts -->
    <script src="{{ asset('build/js/custom.min.js') }}"></script>

    @if ($message = Session::get('success'))
        <script>
            show_toastr('success', '{!! $message !!}');
        </script>
    @endif
    @if ($message = Session::get('error'))
        <script>
            show_toastr('error', '{!! $message !!}');
        </script>
    @endif

</body>

</html>
