@extends('layouts.app')

@section('title')
    Customer
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Permissions</h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('permissions.create') }}" class="btn btn-primary">
                Add New
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="card card-table">
                <div class="card-body">
                    <div class="data-tables">
                        <table id="dataTable" class="text-center">
                            <thead class="bg-light text-capitalize">
                                <tr>
                                    <th>Sl</th>
                                    <th>Name</th>
                                    <th width="60%">Permissions</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($roles as $role)
                                    <tr class="border-bottom">
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $role->name }}</td>
                                        <td>
                                            @foreach ($role->permissions->filter(function($perm) {
                                                return $perm->group_name !== null;
                                            }) as $perm)
                                                <span class="badge badge-info mr-1">
                                                    {{ $perm->name }}
                                                </span>
                                            @endforeach
                                        </td>
                                        <td>
                                            <a class="btn btn-success btn-sm"
                                                href="{{ route('permissions.edit', $role->id) }}">
                                                Edit
                                            </a>
                                            <form id="delete-form-{{ $role->id }}" class="d-inline"
                                                action="{{ route('permissions.delete', $role->id) }}" method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <a
                                                    class="btn btn-danger btn-sm alert-btn text-white cursor-pointer">Delete</a>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
