@extends('layouts.app')
@section('title')
    Profile
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Profile</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 mb-2">
            <div class="x_panel p-20 rounded">
                <div class="x_title">
                    <h5>User Profile</h5>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content" style="padding:0;">
                    <form action="{{ route('profile.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <div class="d-inline-block position-relative image-hover">
                                        <img class="rounded-circle" src="{{session('user_avatar')}}" alt="user-image"
                                        height="130px;" width="130px;" style="object-fit: cover;" id="user_image_preview">
                                        <label for="user_image" class="position-absolute custom-image-position">
                                            <div class="bg-info rounded text-white cursor-pointer px-2 py-1">Choose</div>
                                            <input type="file" name="user_image" id="user_image"
                                                class="d-none" accept="image/*">
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Name :</label>
                                    <input type="text" id="name" class="form-control" name="name"
                                        value="{{ $user->name }}" required />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email :</label>
                                    <input type="email" id="email" class="form-control" name="email"
                                        value="{{ $user->email }}" required readonly/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="address">Address :</label>
                                    <textarea id="address" class="form-control" name="address" rows="3" maxlength="500" autocomplete="off">{{ $user->address }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phone">Phone :</label>
                                    <input type="number" id="phone" class="form-control" name="phone" oninput="this.value = this.value.slice(0, 11)" value="{{ $user->phone }}" autocomplete="off" />
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <br />
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_title">
                    <h5>Change Password</h5>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content" style="padding:0;">
                    <form id="passwordForm" action="{{ route('profile.changePassword') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="password">Enter Password :</label>
                                    <input type="password" id="password" class="form-control" name="password"
                                        placeholder="Enter New Password" required />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="repassword">Confirm Password :</label>
                                    <input type="password" id="repassword" class="form-control" name="repassword"
                                        placeholder="Confirm Password" required />
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <br />
                                    <button type="submit" class="btn btn-primary">Change Password</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>

    <script>
        document.getElementById('passwordForm').addEventListener('submit', function (event) {
            var password = document.getElementById('password').value;
            var repassword = document.getElementById('repassword').value;

            if (password.length < 5) {
                event.preventDefault();
                show_toastr('error', 'Password must be at least 5 characters.');
            } else if (password !== repassword) {
                event.preventDefault();
                show_toastr('error', 'Passwords do not match.');
            }
        });

        document.getElementById('user_image').onchange = function() {
            var src = URL.createObjectURL(this.files[0])
            document.getElementById('user_image_preview').src = src
        }

    </script>
@endsection
